/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.bindings.event.PlayerEvents;
import dev.latvian.mods.kubejs.item.ItemClickedEventJS;
import dev.latvian.mods.kubejs.item.ItemCraftedEventJS;
import dev.latvian.mods.kubejs.item.ItemDroppedEventJS;
import dev.latvian.mods.kubejs.item.ItemEntityInteractedEventJS;
import dev.latvian.mods.kubejs.item.ItemPickedUpEventJS;
import dev.latvian.mods.kubejs.item.ItemSmeltedEventJS;
import dev.latvian.mods.kubejs.player.InventoryChangedEventJS;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class KubeJSItemEventHandler {
    public static void init() {
        InteractionEvent.RIGHT_CLICK_ITEM.register(KubeJSItemEventHandler::rightClick);
        PlayerEvent.PICKUP_ITEM_PRE.register(KubeJSItemEventHandler::canPickUp);
        PlayerEvent.PICKUP_ITEM_POST.register(KubeJSItemEventHandler::pickup);
        PlayerEvent.DROP_ITEM.register(KubeJSItemEventHandler::drop);
        InteractionEvent.INTERACT_ENTITY.register(KubeJSItemEventHandler::entityInteract);
        PlayerEvent.CRAFT_ITEM.register(KubeJSItemEventHandler::crafted);
        PlayerEvent.SMELT_ITEM.register(KubeJSItemEventHandler::smelted);
    }

    private static CompoundEventResult<class_1799> rightClick(class_1657 player, class_1268 hand) {
        if (!ItemEvents.RIGHT_CLICKED.hasListeners()) {
            return CompoundEventResult.pass();
        }
        class_1799 stack = player.method_5998(hand);
        if (!player.method_7357().method_7904(stack.method_7909())) {
            return ItemEvents.RIGHT_CLICKED.post((ScriptTypeHolder)player, (Object)stack.method_7909(), new ItemClickedEventJS(player, hand, stack)).archCompound();
        }
        return CompoundEventResult.pass();
    }

    private static EventResult canPickUp(class_1657 player, class_1542 entity, class_1799 stack) {
        return ItemEvents.CAN_PICK_UP.hasListeners() ? ItemEvents.CAN_PICK_UP.post((ScriptTypeHolder)player, (Object)stack.method_7909(), new ItemPickedUpEventJS(player, entity, stack)).arch() : EventResult.pass();
    }

    private static void pickup(class_1657 player, class_1542 entity, class_1799 stack) {
        if (ItemEvents.PICKED_UP.hasListeners()) {
            ItemEvents.PICKED_UP.post((ScriptTypeHolder)player, (Object)stack.method_7909(), new ItemPickedUpEventJS(player, entity, stack));
        }
    }

    private static EventResult drop(class_1657 player, class_1542 entity) {
        return ItemEvents.DROPPED.hasListeners() ? ItemEvents.DROPPED.post((ScriptTypeHolder)player, (Object)entity.method_6983().method_7909(), new ItemDroppedEventJS(player, entity)).arch() : EventResult.pass();
    }

    private static EventResult entityInteract(class_1657 player, class_1297 entity, class_1268 hand) {
        return ItemEvents.ENTITY_INTERACTED.hasListeners() ? ItemEvents.ENTITY_INTERACTED.post((ScriptTypeHolder)player, (Object)player.method_5998(hand).method_7909(), new ItemEntityInteractedEventJS(player, entity, hand)).arch() : EventResult.pass();
    }

    private static void crafted(class_1657 player, class_1799 stack, class_1263 grid) {
        if (!stack.method_7960()) {
            if (ItemEvents.CRAFTED.hasListeners()) {
                ItemEvents.CRAFTED.post((ScriptTypeHolder)player, (Object)stack.method_7909(), new ItemCraftedEventJS(player, stack, grid));
            }
            if (PlayerEvents.INVENTORY_CHANGED.hasListeners()) {
                PlayerEvents.INVENTORY_CHANGED.post((ScriptTypeHolder)player, (Object)stack.method_7909(), new InventoryChangedEventJS(player, stack, -1));
            }
        }
    }

    private static void smelted(class_1657 player, class_1799 stack) {
        if (!stack.method_7960()) {
            if (ItemEvents.SMELTED.hasListeners()) {
                ItemEvents.SMELTED.post((ScriptTypeHolder)player, (Object)stack.method_7909(), new ItemSmeltedEventJS(player, stack));
            }
            if (PlayerEvents.INVENTORY_CHANGED.hasListeners()) {
                PlayerEvents.INVENTORY_CHANGED.post((ScriptTypeHolder)player, (Object)stack.method_7909(), new InventoryChangedEventJS(player, stack, -1));
            }
        }
    }
}

