/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.spongepowered.configurate.loader;

import com.vecoo.extralib.shade.checkerframework.checker.nullness.qual.Nullable;
import com.vecoo.extralib.shade.kyori.option.Option;
import com.vecoo.extralib.shade.kyori.option.value.ValueSource;
import com.vecoo.extralib.shade.spongepowered.configurate.ConfigurationNode;
import com.vecoo.extralib.shade.spongepowered.configurate.serialize.SerializationException;
import java.util.Objects;
import java.util.regex.Pattern;

final class ValueSources {
    private ValueSources() {
    }

    public static ValueSource node(ConfigurationNode node) {
        return new Node(Objects.requireNonNull(node, "node"));
    }

    static final class Node
    implements ValueSource {
        private static final Pattern PATH_SPLIT = Pattern.compile("[:/]");
        private final ConfigurationNode source;

        Node(ConfigurationNode source) {
            this.source = source;
        }

        @Override
        public <T> @Nullable T value(Option<T> option) {
            String[] path = PATH_SPLIT.split(option.id(), -1);
            try {
                return this.source.node(path).get(option.valueType().type());
            }
            catch (SerializationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

