/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.replication.fluent;

import com.vecoo.extralib.shade.checkerframework.checker.nullness.qual.Nullable;
import com.vecoo.extralib.shade.postgresql.core.BaseConnection;
import com.vecoo.extralib.shade.postgresql.core.ServerVersion;
import com.vecoo.extralib.shade.postgresql.replication.fluent.ChainedCommonCreateSlotBuilder;
import com.vecoo.extralib.shade.postgresql.util.GT;
import java.sql.SQLFeatureNotSupportedException;

public abstract class AbstractCreateSlotBuilder<T extends ChainedCommonCreateSlotBuilder<T>>
implements ChainedCommonCreateSlotBuilder<T> {
    protected @Nullable String slotName;
    protected boolean temporaryOption;
    protected BaseConnection connection;

    protected AbstractCreateSlotBuilder(BaseConnection connection) {
        this.connection = connection;
    }

    protected abstract T self();

    @Override
    public T withSlotName(String slotName) {
        this.slotName = slotName;
        return this.self();
    }

    @Override
    public T withTemporaryOption() throws SQLFeatureNotSupportedException {
        if (!this.connection.haveMinimumServerVersion(ServerVersion.v10)) {
            throw new SQLFeatureNotSupportedException(GT.tr("Server does not support temporary replication slots", new Object[0]));
        }
        this.temporaryOption = true;
        return this.self();
    }
}

