/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.result;

import com.vecoo.extralib.shade.mysql.cj.Messages;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertyKey;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertySet;
import com.vecoo.extralib.shade.mysql.cj.exceptions.DataConversionException;
import com.vecoo.extralib.shade.mysql.cj.exceptions.DataReadException;
import com.vecoo.extralib.shade.mysql.cj.protocol.InternalDate;
import com.vecoo.extralib.shade.mysql.cj.protocol.InternalTime;
import com.vecoo.extralib.shade.mysql.cj.protocol.InternalTimestamp;
import com.vecoo.extralib.shade.mysql.cj.protocol.a.MysqlTextValueDecoder;
import com.vecoo.extralib.shade.mysql.cj.result.AbstractDateTimeValueFactory;
import com.vecoo.extralib.shade.mysql.cj.result.Field;
import com.vecoo.extralib.shade.mysql.cj.util.StringUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;

public class OffsetDateTimeValueFactory
extends AbstractDateTimeValueFactory<OffsetDateTime> {
    private TimeZone defaultTimeZone;
    private TimeZone connectionTimeZone;

    public OffsetDateTimeValueFactory(PropertySet pset, TimeZone defaultTimeZone, TimeZone connectionTimeZone) {
        super(pset);
        this.defaultTimeZone = defaultTimeZone;
        this.connectionTimeZone = connectionTimeZone;
    }

    @Override
    public OffsetDateTime localCreateFromTime(InternalTime it) {
        if (it.getHours() < 0 || it.getHours() >= 24) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidTimeValue", new Object[]{it.toString()}));
        }
        return LocalDateTime.of(1970, 1, 1, it.getHours(), it.getMinutes(), it.getSeconds(), it.getNanos()).atZone(this.defaultTimeZone.toZoneId()).toOffsetDateTime();
    }

    @Override
    public OffsetDateTime localCreateFromTimestamp(InternalTimestamp its) {
        if (its.getYear() == 0 && its.getMonth() == 0 && its.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        return LocalDateTime.of(its.getYear(), its.getMonth(), its.getDay(), its.getHours(), its.getMinutes(), its.getSeconds(), its.getNanos()).atZone((this.pset.getBooleanProperty(PropertyKey.preserveInstants).getValue() != false ? this.connectionTimeZone : this.defaultTimeZone).toZoneId()).toOffsetDateTime();
    }

    @Override
    public OffsetDateTime localCreateFromDate(InternalDate idate) {
        if (idate.getYear() == 0 && idate.getMonth() == 0 && idate.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        return LocalDateTime.of(idate.getYear(), idate.getMonth(), idate.getDay(), 0, 0, 0, 0).atZone(this.defaultTimeZone.toZoneId()).toOffsetDateTime();
    }

    @Override
    public OffsetDateTime localCreateFromDatetime(InternalTimestamp its) {
        if (its.getYear() == 0 && its.getMonth() == 0 && its.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        return LocalDateTime.of(its.getYear(), its.getMonth(), its.getDay(), its.getHours(), its.getMinutes(), its.getSeconds(), its.getNanos()).atZone((this.pset.getBooleanProperty(PropertyKey.preserveInstants).getValue() != false ? this.connectionTimeZone : this.defaultTimeZone).toZoneId()).toOffsetDateTime();
    }

    @Override
    public OffsetDateTime createFromBytes(byte[] bytes, int offset, int length, Field f) {
        if (length == 0 && this.pset.getBooleanProperty(PropertyKey.emptyStringsConvertToZero).getValue().booleanValue()) {
            return (OffsetDateTime)this.createFromLong(0L);
        }
        String s2 = StringUtils.toString(bytes, offset, length, f.getEncoding());
        byte[] newBytes = s2.getBytes();
        if (MysqlTextValueDecoder.isDate(s2)) {
            return (OffsetDateTime)this.createFromDate(MysqlTextValueDecoder.getDate(newBytes, 0, newBytes.length));
        }
        if (MysqlTextValueDecoder.isTime(s2)) {
            return (OffsetDateTime)this.createFromTime(MysqlTextValueDecoder.getTime(newBytes, 0, newBytes.length, f.getDecimals()));
        }
        if (MysqlTextValueDecoder.isTimestamp(s2)) {
            return (OffsetDateTime)this.createFromTimestamp(MysqlTextValueDecoder.getTimestamp(newBytes, 0, newBytes.length, f.getDecimals()));
        }
        try {
            return OffsetDateTime.parse(s2.replace(" ", "T"));
        }
        catch (DateTimeParseException e) {
            throw new DataConversionException(Messages.getString("ResultSet.UnableToConvertString", new Object[]{s2, this.getTargetTypeName()}));
        }
    }

    @Override
    public String getTargetTypeName() {
        return OffsetDateTime.class.getName();
    }
}

