/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.core.DisplayInfoFTBL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_161;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class KnownServerRegistries {
    public static KnownServerRegistries client;
    public static KnownServerRegistries server;
    public final List<class_2960> dimensions;
    public final Map<class_2960, AdvancementInfo> advancements;

    public KnownServerRegistries(class_2540 buffer) {
        int i;
        int s = buffer.method_10816();
        this.dimensions = new ArrayList<class_2960>(s);
        for (i = 0; i < s; ++i) {
            this.dimensions.add(buffer.method_10810());
        }
        s = buffer.method_10816();
        this.advancements = new LinkedHashMap<class_2960, AdvancementInfo>(s);
        for (i = 0; i < s; ++i) {
            AdvancementInfo info = new AdvancementInfo();
            info.id = buffer.method_10810();
            info.name = buffer.method_10808();
            info.icon = buffer.method_10819();
            this.advancements.put(info.id, info);
        }
        FTBLibrary.LOGGER.debug("Received server registries");
    }

    public KnownServerRegistries(MinecraftServer server) {
        this.dimensions = new ArrayList<class_2960>();
        for (class_3218 level : server.method_3738()) {
            this.dimensions.add(level.method_27983().method_29177());
        }
        this.dimensions.sort(null);
        ArrayList<AdvancementInfo> advancementList = new ArrayList<AdvancementInfo>();
        for (class_161 advancement : server.method_3851().method_12893()) {
            if (!(advancement.method_686() instanceof DisplayInfoFTBL)) continue;
            AdvancementInfo info = new AdvancementInfo();
            info.id = advancement.method_688();
            info.name = advancement.method_686().method_811();
            info.icon = ((DisplayInfoFTBL)advancement.method_686()).getIconStackFTBL();
            advancementList.add(info);
        }
        advancementList.sort(Comparator.comparing(o -> o.id));
        this.advancements = new LinkedHashMap<class_2960, AdvancementInfo>(advancementList.size());
        for (AdvancementInfo info : advancementList) {
            this.advancements.put(info.id, info);
        }
    }

    public void write(class_2540 buffer) {
        buffer.method_10804(this.dimensions.size());
        for (class_2960 id : this.dimensions) {
            buffer.method_10812(id);
        }
        buffer.method_10804(this.advancements.size());
        for (AdvancementInfo info : this.advancements.values()) {
            buffer.method_10812(info.id);
            buffer.method_10805(info.name);
            buffer.method_10793(info.icon);
        }
    }

    public static class AdvancementInfo {
        public class_2960 id;
        public class_2561 name;
        public class_1799 icon;
    }
}

