/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.datafixer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.ZipException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2861;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_5218;
import net.minecraft.class_524;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.datafixer.MigrationProfile;
import org.betterx.bclib.api.v2.datafixer.Patch;
import org.betterx.bclib.api.v2.datafixer.PatchDidiFailException;
import org.betterx.bclib.client.gui.screens.AtomicProgressListener;
import org.betterx.bclib.client.gui.screens.ConfirmFixScreen;
import org.betterx.bclib.client.gui.screens.LevelFixErrorScreen;
import org.betterx.bclib.client.gui.screens.ProgressScreen;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.util.Logger;
import org.betterx.worlds.together.world.WorldConfig;
import org.jetbrains.annotations.NotNull;

public class DataFixerAPI {
    static final Logger LOGGER = new Logger("DataFixerAPI");
    static class_2487 patchConfTag = null;

    private static boolean wrapCall(class_32 levelSource, String levelID, Function<class_32.class_5143, Boolean> runWithLevel) {
        class_32.class_5143 levelStorageAccess;
        try {
            levelStorageAccess = levelSource.method_27002(levelID);
        }
        catch (IOException e) {
            BCLib.LOGGER.warning("Failed to read level {} data", (Object)levelID, e);
            class_370.method_27023((class_310)class_310.method_1551(), (String)levelID);
            class_310.method_1551().method_1507(null);
            return true;
        }
        boolean returnValue = runWithLevel.apply(levelStorageAccess);
        try {
            levelStorageAccess.close();
        }
        catch (IOException e) {
            BCLib.LOGGER.warning("Failed to unlock access to level {}", (Object)levelID, e);
        }
        return returnValue;
    }

    public static boolean fixData(class_32 levelSource, String levelID, boolean showUI, Consumer<Boolean> onResume) {
        return DataFixerAPI.wrapCall(levelSource, levelID, levelStorageAccess -> DataFixerAPI.fixData(levelStorageAccess, showUI, onResume));
    }

    public static boolean fixData(class_32.class_5143 levelStorageAccess, boolean showUI, Consumer<Boolean> onResume) {
        File levelPath = levelStorageAccess.method_27010(class_5218.field_24188).toFile();
        return DataFixerAPI.fixData(levelPath, levelStorageAccess.method_27005(), showUI, onResume);
    }

    public static void initializePatchData() {
        DataFixerAPI.getMigrationProfile().markApplied();
        WorldConfig.saveFile("bclib");
    }

    @Environment(value=EnvType.CLIENT)
    private static AtomicProgressListener showProgressScreen() {
        ProgressScreen ps = new ProgressScreen(class_310.method_1551().field_1755, (class_2561)class_2561.method_43471((String)"title.bclib.datafixer.progress"), (class_2561)class_2561.method_43471((String)"message.bclib.datafixer.progress"));
        class_310.method_1551().method_1507((class_437)ps);
        return ps;
    }

    private static boolean fixData(File dir, String levelID, boolean showUI, Consumer<Boolean> onResume) {
        MigrationProfile profile = DataFixerAPI.loadProfileIfNeeded(dir);
        BiConsumer<Boolean, Boolean> runFixes = (createBackup, applyFixes) -> {
            AtomicProgressListener progress = applyFixes.booleanValue() ? (showUI ? DataFixerAPI.showProgressScreen() : new AtomicProgressListener(){
                private long timeStamp = class_156.method_658();
                private AtomicInteger counter = new AtomicInteger(0);

                @Override
                public void incAtomic(int maxProgress) {
                    int percentage = 100 * this.counter.incrementAndGet() / maxProgress;
                    if (class_156.method_658() - this.timeStamp >= 1000L) {
                        this.timeStamp = class_156.method_658();
                        BCLib.LOGGER.info("Patching... {}%", percentage);
                    }
                }

                @Override
                public void resetAtomic() {
                    this.counter = new AtomicInteger(0);
                }

                @Override
                public void method_15411() {
                }

                @Override
                public void method_15414(class_2561 component) {
                    BCLib.LOGGER.info("Patcher Stage... {}%", component.getString());
                }
            }) : null;
            Supplier<State> runner = () -> {
                if (createBackup.booleanValue()) {
                    progress.method_15414((class_2561)class_2561.method_43471((String)"message.bclib.datafixer.progress.waitbackup"));
                    class_524.method_29784((class_32)class_310.method_1551().method_1586(), (String)levelID);
                }
                if (applyFixes.booleanValue()) {
                    return DataFixerAPI.runDataFixes(dir, profile, progress);
                }
                return new State();
            };
            if (showUI) {
                Thread fixerThread = new Thread(() -> {
                    State state = (State)runner.get();
                    class_310.method_1551().execute(() -> {
                        if (profile != null && showUI) {
                            if (state.didFail || state.hasError()) {
                                DataFixerAPI.showLevelFixErrorScreen(state, markFixed -> {
                                    if (markFixed) {
                                        profile.markApplied();
                                    }
                                    onResume.accept((Boolean)applyFixes);
                                });
                            } else {
                                onResume.accept((Boolean)applyFixes);
                            }
                        }
                    });
                });
                fixerThread.start();
            } else {
                State state = runner.get();
                if (state.hasError()) {
                    LOGGER.error("There were Errors while fixing the Level:");
                    LOGGER.error(state.getErrorMessage());
                }
            }
        };
        if (profile != null) {
            if (showUI) {
                DataFixerAPI.showBackupWarning(levelID, runFixes);
                return true;
            }
            BCLib.LOGGER.warning("Applying Fixes on Level", new Object[0]);
            runFixes.accept(false, true);
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static void showLevelFixErrorScreen(State state, LevelFixErrorScreen.Listener onContinue) {
        class_310.method_1551().method_1507((class_437)new LevelFixErrorScreen(class_310.method_1551().field_1755, state.getErrorMessages(), onContinue));
    }

    private static MigrationProfile loadProfileIfNeeded(File levelBaseDir) {
        if (!Configs.MAIN_CONFIG.applyPatches()) {
            LOGGER.info("World Patches are disabled");
            return null;
        }
        MigrationProfile profile = DataFixerAPI.getMigrationProfile();
        profile.runPrePatches(levelBaseDir);
        if (!profile.hasAnyFixes()) {
            LOGGER.info("Everything up to date");
            return null;
        }
        return profile;
    }

    @NotNull
    private static MigrationProfile getMigrationProfile() {
        class_2487 patchConfig = WorldConfig.getCompoundTag("bclib", "patches");
        MigrationProfile profile = Patch.createMigrationData(patchConfig);
        return profile;
    }

    @Environment(value=EnvType.CLIENT)
    static void showBackupWarning(String levelID, BiConsumer<Boolean, Boolean> whenFinished) {
        class_310.method_1551().method_1507((class_437)new ConfirmFixScreen(null, whenFinished::accept));
    }

    private static State runDataFixes(File dir, MigrationProfile profile, AtomicProgressListener progress) {
        State state = new State();
        progress.resetAtomic();
        progress.method_15414((class_2561)class_2561.method_43471((String)"message.bclib.datafixer.progress.reading"));
        List<File> players = DataFixerAPI.getAllPlayers(dir);
        List<File> regions = DataFixerAPI.getAllRegions(dir, null);
        int maxProgress = players.size() + regions.size() + 4;
        progress.incAtomic(maxProgress);
        progress.method_15414((class_2561)class_2561.method_43471((String)"message.bclib.datafixer.progress.players"));
        players.parallelStream().forEach(file -> {
            DataFixerAPI.fixPlayer(profile, state, file);
            progress.incAtomic(maxProgress);
        });
        progress.method_15414((class_2561)class_2561.method_43471((String)"message.bclib.datafixer.progress.level"));
        DataFixerAPI.fixLevel(profile, state, dir);
        progress.incAtomic(maxProgress);
        progress.method_15414((class_2561)class_2561.method_43471((String)"message.bclib.datafixer.progress.worlddata"));
        try {
            profile.patchWorldData();
        }
        catch (PatchDidiFailException e) {
            state.didFail = true;
            state.addError("Failed fixing worldconfig (" + e.getMessage() + ")");
            BCLib.LOGGER.error(e.getMessage());
        }
        progress.incAtomic(maxProgress);
        progress.method_15414((class_2561)class_2561.method_43471((String)"message.bclib.datafixer.progress.regions"));
        regions.parallelStream().forEach(file -> {
            DataFixerAPI.fixRegion(profile, state, file);
            progress.incAtomic(maxProgress);
        });
        if (!state.didFail) {
            progress.method_15414((class_2561)class_2561.method_43471((String)"message.bclib.datafixer.progress.saving"));
            profile.markApplied();
            WorldConfig.saveFile("bclib");
        }
        progress.incAtomic(maxProgress);
        progress.method_15411();
        return state;
    }

    private static void fixLevel(MigrationProfile profile, State state, File levelBaseDir) {
        try {
            class_2487 dataTag;
            LOGGER.info("Inspecting level.dat in " + levelBaseDir);
            class_2487 level = profile.getLevelDat(levelBaseDir);
            boolean[] changed = new boolean[]{profile.isLevelDatChanged()};
            if (profile.getPrePatchException() != null) {
                throw profile.getPrePatchException();
            }
            if (level.method_10545("Data") && (dataTag = (class_2487)level.method_10580("Data")).method_10545("Player")) {
                class_2487 player = (class_2487)dataTag.method_10580("Player");
                DataFixerAPI.fixPlayerNbt(player, changed, profile);
            }
            if (changed[0]) {
                LOGGER.warning("Writing '{}'", profile.getLevelDatFile());
                class_2507.method_30614((class_2487)level, (File)profile.getLevelDatFile());
            }
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed fixing Level-Data.");
            state.addError("Failed fixing Level-Data in level.dat (" + e.getMessage() + ")");
            state.didFail = true;
            e.printStackTrace();
        }
    }

    private static void fixPlayer(MigrationProfile data, State state, File file) {
        try {
            LOGGER.info("Inspecting " + file);
            class_2487 player = DataFixerAPI.readNbt(file);
            boolean[] changed = new boolean[]{false};
            DataFixerAPI.fixPlayerNbt(player, changed, data);
            if (changed[0]) {
                LOGGER.warning("Writing '{}'", file);
                class_2507.method_30614((class_2487)player, (File)file);
            }
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed fixing Player-Data.");
            state.addError("Failed fixing Player-Data in " + file.getName() + " (" + e.getMessage() + ")");
            state.didFail = true;
            e.printStackTrace();
        }
    }

    private static void fixPlayerNbt(class_2487 player, boolean[] changed, MigrationProfile data) {
        class_2499 inventory = player.method_10554("Inventory", 10);
        DataFixerAPI.fixItemArrayWithID(inventory, changed, data, true);
        class_2499 enderitems = player.method_10554("EnderItems", 10);
        DataFixerAPI.fixItemArrayWithID(enderitems, changed, data, true);
        if (player.method_10545("recipeBook")) {
            class_2487 recipeBook = player.method_10562("recipeBook");
            changed[0] = changed[0] | DataFixerAPI.fixStringIDList(recipeBook, "recipes", data);
            changed[0] = changed[0] | DataFixerAPI.fixStringIDList(recipeBook, "toBeDisplayed", data);
        }
    }

    static boolean fixStringIDList(class_2487 root, String name, MigrationProfile data) {
        boolean _changed = false;
        if (root.method_10545(name)) {
            class_2499 items = root.method_10554(name, 8);
            class_2499 newItems = new class_2499();
            for (class_2520 tag : items) {
                class_2519 str = (class_2519)tag;
                String replace = data.replaceStringFromIDs(str.method_10714());
                if (replace != null) {
                    _changed = true;
                    newItems.add((Object)class_2519.method_23256((String)replace));
                    continue;
                }
                newItems.add((Object)tag);
            }
            if (_changed) {
                root.method_10566(name, (class_2520)newItems);
            }
        }
        return _changed;
    }

    private static void fixRegion(MigrationProfile data, State state, File file) {
        try {
            Path path = file.toPath();
            LOGGER.info("Inspecting " + path);
            boolean[] changed = new boolean[1];
            class_2861 region = new class_2861(path, path.getParent(), true);
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    class_1923 pos = new class_1923(x, z);
                    changed[0] = false;
                    if (!region.method_12423(pos) || state.didFail) continue;
                    DataInputStream input = region.method_21873(pos);
                    class_2487 root = class_2507.method_10627((DataInput)input);
                    input.close();
                    class_2499 tileEntities = root.method_10562("Level").method_10554("TileEntities", 10);
                    DataFixerAPI.fixItemArrayWithID(tileEntities, changed, data, true);
                    class_2499 entities = root.method_10554("Entities", 10);
                    DataFixerAPI.fixItemArrayWithID(entities, changed, data, true);
                    class_2499 sections = root.method_10562("Level").method_10554("Sections", 10);
                    sections.forEach(tag -> {
                        class_2499 palette = ((class_2487)tag).method_10554("Palette", 10);
                        palette.forEach(blockTag -> {
                            class_2487 blockTagCompound = (class_2487)blockTag;
                            changed[0] = changed[0] | data.replaceStringFromIDs(blockTagCompound, "Name");
                        });
                        try {
                            changed[0] = changed[0] | data.patchBlockState(palette, ((class_2487)tag).method_10554("BlockStates", 4));
                        }
                        catch (PatchDidiFailException e) {
                            BCLib.LOGGER.error("Failed fixing BlockState in " + pos);
                            state.addError("Failed fixing BlockState in " + pos + " (" + e.getMessage() + ")");
                            state.didFail = true;
                            changed[0] = false;
                            e.printStackTrace();
                        }
                    });
                    if (!changed[0]) continue;
                    LOGGER.warning("Writing '{}': {}/{}", file, x, z);
                    DataOutputStream output = region.method_21881(pos);
                    class_2507.method_10628((class_2487)root, (DataOutput)output);
                    output.close();
                }
            }
            region.close();
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed fixing Region.");
            state.addError("Failed fixing Region in " + file.getName() + " (" + e.getMessage() + ")");
            state.didFail = true;
            e.printStackTrace();
        }
    }

    static class_2487 getPatchData() {
        if (patchConfTag == null) {
            patchConfTag = WorldConfig.getCompoundTag("bclib", "patches");
        }
        return patchConfTag;
    }

    static void fixItemArrayWithID(class_2499 items, boolean[] changed, MigrationProfile data, boolean recursive) {
        items.forEach(inTag -> DataFixerAPI.fixID((class_2487)inTag, changed, data, recursive));
    }

    static void fixID(class_2487 inTag, boolean[] changed, MigrationProfile data, boolean recursive) {
        class_2487 entityTag;
        class_2487 tag = inTag;
        changed[0] = changed[0] | data.replaceStringFromIDs(tag, "id");
        if (tag.method_10545("Item")) {
            class_2487 item = (class_2487)tag.method_10580("Item");
            DataFixerAPI.fixID(item, changed, data, recursive);
        }
        if (recursive && tag.method_10545("Items")) {
            DataFixerAPI.fixItemArrayWithID(tag.method_10554("Items", 10), changed, data, true);
        }
        if (recursive && tag.method_10545("Inventory")) {
            class_2499 inventory = tag.method_10554("Inventory", 10);
            DataFixerAPI.fixItemArrayWithID(inventory, changed, data, true);
        }
        if (tag.method_10545("tag") && (entityTag = (class_2487)tag.method_10580("tag")).method_10545("BlockEntityTag")) {
            class_2487 blockEntityTag = (class_2487)entityTag.method_10580("BlockEntityTag");
            DataFixerAPI.fixID(blockEntityTag, changed, data, recursive);
        }
    }

    private static List<File> getAllPlayers(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        if (!(dir = new File(dir, "playerdata")).exists() || !dir.isDirectory()) {
            return list;
        }
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".dat")) continue;
            list.add(file);
        }
        return list;
    }

    private static List<File> getAllRegions(File dir, List<File> list) {
        if (list == null) {
            list = new ArrayList<File>();
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                DataFixerAPI.getAllRegions(file, list);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".mca")) continue;
            list.add(file);
        }
        return list;
    }

    public static void registerPatch(Supplier<Patch> patch) {
        Patch.getALL().add(patch.get());
    }

    private static class_2487 readNbt(File file) throws IOException {
        try {
            return class_2507.method_30613((File)file);
        }
        catch (EOFException | ZipException e) {
            return class_2507.method_10633((File)file);
        }
    }

    static class State {
        public boolean didFail = false;
        protected ArrayList<String> errors = new ArrayList();

        State() {
        }

        public void addError(String s) {
            this.errors.add(s);
        }

        public boolean hasError() {
            return this.errors.size() > 0;
        }

        public String getErrorMessage() {
            return this.errors.stream().reduce("", (a, b) -> a + "  - " + b + "\n");
        }

        public String[] getErrorMessages() {
            String[] res = new String[this.errors.size()];
            return this.errors.toArray(res);
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void call();
    }
}

