/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablepets.items;

import com.shiftthedev.pickablepets.PickablePets;
import com.shiftthedev.pickablepets.compat.DawnEraHelper;
import com.shiftthedev.pickablepets.compat.DoggyHelper;
import com.shiftthedev.pickablepets.compat.DomesticationHelper;
import com.shiftthedev.pickablepets.compat.GoetyHelper;
import com.shiftthedev.pickablepets.utils.CachedPets;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6025;
import net.minecraft.class_7298;
import org.jetbrains.annotations.Nullable;

public class PetItem
extends class_1792 {
    public static final int VERSION = 2;

    public PetItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_1657 class_16572 = ctx.method_8036();
        if (!(class_16572 instanceof class_3222)) {
            return class_1269.field_5812;
        }
        class_3222 player = (class_3222)class_16572;
        class_1937 level = ctx.method_8045();
        if (ctx.method_20287() != class_1268.field_5808) {
            return class_1269.field_5814;
        }
        class_1799 itemStack = ctx.method_8041();
        class_2487 tag = itemStack.method_7911("pet_info");
        class_2338 blockPos = ctx.method_8037();
        class_2350 direction = ctx.method_8038();
        class_2680 blockState = level.method_8320(blockPos);
        return this.placePet((class_1657)player, level, blockState, blockPos, direction, itemStack, tag);
    }

    private class_1269 placePet(class_1657 player, class_1937 level, class_2680 blockState, class_2338 blockPos, class_2350 direction, class_1799 itemStack, class_2487 tag) {
        UUID petUUID = tag.method_25926("UUID");
        class_1309 cachedPet = CachedPets.getPet(petUUID);
        if (cachedPet == null) {
            return class_1269.field_5814;
        }
        boolean isException = false;
        if (Platform.isForge()) {
            if (PickablePets.FoundDomestication && DomesticationHelper.isFromMod(cachedPet) && !DomesticationHelper.isOwner(cachedPet, (class_3222)player)) {
                return class_1269.field_5814;
            }
            if (PickablePets.FoundDawnEra && DawnEraHelper.isFromMod(cachedPet) && !DawnEraHelper.isOwner(cachedPet, (class_1309)player)) {
                return class_1269.field_5814;
            }
            if (PickablePets.FoundGoety && GoetyHelper.isFromMod(cachedPet) && !GoetyHelper.isOwner(cachedPet, (class_1309)player)) {
                return class_1269.field_5814;
            }
        }
        if (!(isException || cachedPet instanceof class_7298 || player.method_5667().equals(((class_6025)cachedPet).method_6139()))) {
            return class_1269.field_5814;
        }
        if (!blockState.method_26220((class_1922)level, blockPos).method_1110()) {
            blockPos = direction == class_2350.field_11033 ? blockPos.method_10079(direction, 2) : blockPos.method_10093(direction);
        }
        class_2338 finalBlockPos = blockPos;
        level.method_8503().execute(() -> {
            if (PickablePets.FoundDoggy && DoggyHelper.isFromMod(cachedPet)) {
                class_1309 pet = DoggyHelper.reviveDog(cachedPet, petUUID, player, (class_3218)level, finalBlockPos);
                if (pet == null) {
                    return;
                }
                if (player.method_7337()) {
                    player.method_31548().method_7378(itemStack);
                } else {
                    itemStack.method_7939(0);
                }
            } else {
                class_1309 pet = (class_1309)cachedPet.method_5864().method_5883(level);
                if (pet == null) {
                    return;
                }
                pet.method_5878((class_1297)cachedPet);
                pet.method_6127().method_26850(CachedPets.getPetAttributes(petUUID));
                pet.method_33574(class_243.method_24953((class_2382)finalBlockPos));
                if (!level.method_8649((class_1297)pet)) {
                    return;
                }
                if (player.method_7337()) {
                    player.method_31548().method_7378(itemStack);
                } else {
                    itemStack.method_7939(0);
                }
                CachedPets.addPet(pet);
                CachedPets.sendPetsToPlayers(level, petUUID);
            }
            CachedPets.setPetItem(petUUID, false);
            level.method_16107().method_15407();
        });
        return class_1269.field_5812;
    }

    public void method_33261(class_1542 itemEntity) {
        class_2487 tag = itemEntity.method_6983().method_7911("pet_info");
        if (!tag.method_10545("UUID")) {
            return;
        }
        CachedPets.killPet(tag.method_25926("UUID"));
    }

    public class_2561 method_7864(class_1799 itemStack) {
        if (itemStack.method_7938()) {
            return itemStack.method_7964();
        }
        class_2487 tag = itemStack.method_7911("pet_info");
        return CachedPets.getPetName(tag.method_25926("UUID"));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        super.method_7851(itemStack, level, list, tooltipFlag);
        class_2487 tag = itemStack.method_7911("pet_info");
        if (!tag.method_10545("UUID")) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.pickablepets.empty"));
            return;
        }
        list.add((class_2561)class_2561.method_43469((String)"tooltip.pickablepets.owner", (Object[])new Object[]{CachedPets.getOwner(tag.method_25926("UUID"))}));
    }
}

