/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.tacz.guns.config.util.HeadShotAABBConfigRead;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.util.HitboxHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    private static final Predicate<class_1297> PROJECTILE_TARGETS = input -> input != null && input.method_5863() && !input.method_7325();

    @Nullable
    public static EntityKineticBullet.EntityResult findEntityOnPath(class_1676 bulletEntity, class_243 startVec, class_243 endVec) {
        class_243 hitVec = null;
        class_1297 hitEntity = null;
        boolean headshot = false;
        List entities = bulletEntity.method_37908().method_8333((class_1297)bulletEntity, bulletEntity.method_5829().method_18804(bulletEntity.method_18798()).method_1014(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        class_1297 owner = bulletEntity.method_24921();
        for (class_1297 entity : entities) {
            EntityKineticBullet.EntityResult result;
            if (entity.equals((Object)owner) || owner != null && entity.method_5794(owner) || (result = EntityUtil.getHitResult(bulletEntity, entity, startVec, endVec)) == null) continue;
            class_243 hitPos = result.getHitPos();
            double distanceToHit = startVec.method_1022(hitPos);
            if (!entity.method_5805() || !(distanceToHit < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new EntityKineticBullet.EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @NotNull
    public static List<EntityKineticBullet.EntityResult> findEntitiesOnPath(class_1676 bulletEntity, class_243 startVec, class_243 endVec) {
        ArrayList<EntityKineticBullet.EntityResult> hitEntities = new ArrayList<EntityKineticBullet.EntityResult>();
        List entities = bulletEntity.method_37908().method_8333((class_1297)bulletEntity, bulletEntity.method_5829().method_18804(bulletEntity.method_18798()).method_1014(1.0), PROJECTILE_TARGETS);
        class_1297 owner = bulletEntity.method_24921();
        for (class_1297 entity : entities) {
            EntityKineticBullet.EntityResult result;
            if (entity.equals((Object)owner) || owner != null && entity.equals((Object)owner.method_5854()) || (result = EntityUtil.getHitResult(bulletEntity, entity, startVec, endVec)) == null || !entity.method_5805()) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    protected static EntityKineticBullet.EntityResult getHitResult(class_1676 bulletEntity, class_1297 entity, class_243 startVec, class_243 endVec) {
        class_238 aabb;
        class_238 boundingBox = HitboxHelper.getFixedBoundingBox(entity, bulletEntity.method_24921());
        class_243 hitPos = boundingBox.method_992(startVec, endVec).orElse(null);
        if (hitPos == null) {
            return null;
        }
        class_243 hitBoxPos = hitPos.method_1020(entity.method_19538());
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        if (entityId != null && (aabb = HeadShotAABBConfigRead.getAABB(entityId)) != null) {
            return new EntityKineticBullet.EntityResult(entity, hitPos, aabb.method_1006(hitBoxPos));
        }
        boolean headshot = false;
        float eyeHeight = entity.method_5751();
        if ((double)eyeHeight - 0.25 < hitBoxPos.field_1351 && hitBoxPos.field_1351 < (double)eyeHeight + 0.25) {
            headshot = true;
        }
        return new EntityKineticBullet.EntityResult(entity, hitPos, headshot);
    }
}

