/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.bedrock;

import com.tacz.guns.client.model.bedrock.BedrockCube;
import com.tacz.guns.client.model.bedrock.BedrockPolygon;
import com.tacz.guns.client.model.bedrock.BedrockVertex;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class BedrockCubeBox
implements BedrockCube {
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;
    private final BedrockPolygon[] polygons;

    public BedrockCubeBox(float texOffX, float texOffY, float x, float y, float z, float width, float height, float depth, float delta, boolean mirror, float texWidth, float texHeight) {
        this.minX = x;
        this.minY = y;
        this.minZ = z;
        this.maxX = x + width;
        this.maxY = y + height;
        this.maxZ = z + depth;
        this.polygons = new BedrockPolygon[6];
        float xEnd = x + width;
        float yEnd = y + height;
        float zEnd = z + depth;
        x -= delta;
        y -= delta;
        z -= delta;
        xEnd += delta;
        yEnd += delta;
        zEnd += delta;
        if (mirror) {
            float tmp = xEnd;
            xEnd = x;
            x = tmp;
        }
        BedrockVertex vertex1 = new BedrockVertex(x, y, z, 0.0f, 0.0f);
        BedrockVertex vertex2 = new BedrockVertex(xEnd, y, z, 0.0f, 8.0f);
        BedrockVertex vertex3 = new BedrockVertex(xEnd, yEnd, z, 8.0f, 8.0f);
        BedrockVertex vertex4 = new BedrockVertex(x, yEnd, z, 8.0f, 0.0f);
        BedrockVertex vertex5 = new BedrockVertex(x, y, zEnd, 0.0f, 0.0f);
        BedrockVertex vertex6 = new BedrockVertex(xEnd, y, zEnd, 0.0f, 8.0f);
        BedrockVertex vertex7 = new BedrockVertex(xEnd, yEnd, zEnd, 8.0f, 8.0f);
        BedrockVertex vertex8 = new BedrockVertex(x, yEnd, zEnd, 8.0f, 0.0f);
        int dx = (int)width;
        int dy = (int)height;
        int dz = (int)depth;
        float p1 = texOffX + (float)dz;
        float p2 = texOffX + (float)dz + (float)dx;
        float p3 = texOffX + (float)dz + (float)dx + (float)dx;
        float p4 = texOffX + (float)dz + (float)dx + (float)dz;
        float p5 = texOffX + (float)dz + (float)dx + (float)dz + (float)dx;
        float p6 = texOffY + (float)dz;
        float p7 = texOffY + (float)dz + (float)dy;
        float p8 = texOffY;
        float p9 = texOffX;
        this.polygons[2] = new BedrockPolygon(new BedrockVertex[]{vertex6, vertex5, vertex1, vertex2}, p1, p8, p2, p6, texWidth, texHeight, mirror, class_2350.field_11033);
        this.polygons[3] = new BedrockPolygon(new BedrockVertex[]{vertex3, vertex4, vertex8, vertex7}, p2, p6, p3, p8, texWidth, texHeight, mirror, class_2350.field_11036);
        this.polygons[1] = new BedrockPolygon(new BedrockVertex[]{vertex1, vertex5, vertex8, vertex4}, p9, p6, p1, p7, texWidth, texHeight, mirror, class_2350.field_11039);
        this.polygons[4] = new BedrockPolygon(new BedrockVertex[]{vertex2, vertex1, vertex4, vertex3}, p1, p6, p2, p7, texWidth, texHeight, mirror, class_2350.field_11043);
        this.polygons[0] = new BedrockPolygon(new BedrockVertex[]{vertex6, vertex2, vertex3, vertex7}, p2, p6, p4, p7, texWidth, texHeight, mirror, class_2350.field_11034);
        this.polygons[5] = new BedrockPolygon(new BedrockVertex[]{vertex5, vertex6, vertex7, vertex8}, p4, p6, p5, p7, texWidth, texHeight, mirror, class_2350.field_11035);
    }

    @Override
    public void compile(class_4587.class_4665 pose, class_4588 consumer, int light, int overlay, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = pose.method_23761();
        Matrix3f matrix3f = pose.method_23762();
        for (BedrockPolygon polygon : this.polygons) {
            Vector3f vector3f = new Vector3f((Vector3fc)polygon.normal);
            vector3f.mul((Matrix3fc)matrix3f);
            float nx = vector3f.x();
            float ny = vector3f.y();
            float nz = vector3f.z();
            for (BedrockVertex vertex : polygon.vertices) {
                float x = vertex.pos.x() / 16.0f;
                float y = vertex.pos.y() / 16.0f;
                float z = vertex.pos.z() / 16.0f;
                Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
                vector4f.mul((Matrix4fc)matrix4f);
                consumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), red, green, blue, alpha, vertex.u, vertex.v, overlay, light, nx, ny, nz);
            }
        }
    }
}

