/*
 * Decompiled with CFR 0.152.
 */
package cn.sh1rocu.tacz.util.itemhandler;

import cn.sh1rocu.tacz.util.itemhandler.IItemHandlerModifiable;
import com.google.common.base.Preconditions;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class RangedWrapper
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable compose;
    private final int minSlot;
    private final int maxSlot;

    public RangedWrapper(IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive) {
        Preconditions.checkArgument((maxSlotExclusive > minSlot ? 1 : 0) != 0, (Object)"Max slot must be greater than min slot");
        this.compose = compose;
        this.minSlot = minSlot;
        this.maxSlot = maxSlotExclusive;
    }

    @Override
    public int getSlots() {
        return this.maxSlot - this.minSlot;
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getStackInSlot(slot + this.minSlot);
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.insertItem(slot + this.minSlot, stack, simulate);
        }
        return stack;
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.extractItem(slot + this.minSlot, amount, simulate);
        }
        return class_1799.field_8037;
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        if (this.checkSlot(slot)) {
            this.compose.setStackInSlot(slot + this.minSlot, stack);
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getSlotLimit(slot + this.minSlot);
        }
        return 0;
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        if (this.checkSlot(slot)) {
            return this.compose.isItemValid(slot + this.minSlot, stack);
        }
        return false;
    }

    private boolean checkSlot(int localSlot) {
        return localSlot + this.minSlot < this.maxSlot;
    }

    public class_2487 serializeNBT() {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            nbtTagList.add((Object)this.getStackInSlot(i).method_7953(itemTag));
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.getSlots());
        return nbt;
    }

    public void deserializeNBT(class_2487 nbt) {
        int size = nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.getSlots();
        class_2499 tagList = nbt.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= size) continue;
            this.setStackInSlot(slot, class_1799.method_7915((class_2487)itemTags));
        }
    }
}

