/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.CypressTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class CypressTreeFeature
extends BOPTreeFeature<CypressTreeConfiguration> {
    public CypressTreeFeature(Codec<CypressTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean method_12775(class_5281 world, class_5819 random, class_2338 startPos, BiConsumer<class_2338, class_2680> roots, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_4643 configBase) {
        int i;
        CypressTreeConfiguration config = (CypressTreeConfiguration)configBase;
        while (startPos.method_10264() >= world.method_31607() + 1 && world.method_22347(startPos) || world.method_8320(startPos).method_26164(class_3481.field_15503)) {
            startPos = startPos.method_10074();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        if (height < 4) {
            return false;
        }
        int baseHeight = height / 3;
        if (config.leavesAtBottom) {
            baseHeight = 0;
        }
        int leavesHeight = height - baseHeight;
        class_2338 pos = startPos.method_10084();
        if (!this.checkSpace((class_1936)world, pos, baseHeight, height)) {
            return false;
        }
        for (i = 0; i < baseHeight; ++i) {
            this.placeLog((class_1936)world, pos, logs, config);
            pos = pos.method_10084();
        }
        for (i = 1; i < leavesHeight - 3; ++i) {
            for (int xx = -1; xx < 2; ++xx) {
                for (int zz = -1; zz < 2; ++zz) {
                    this.placeLeaves((class_1936)world, pos.method_10069(xx, i, zz), leaves, config);
                }
            }
        }
        for (i = 0; i < leavesHeight; ++i) {
            int radius = this.radius(i, leavesHeight);
            this.generateLeafLayer((class_1936)world, pos, radius, leaves, config);
            if (leavesHeight - i > 2) {
                this.placeLog((class_1936)world, pos, logs, config);
            }
            pos = pos.method_10084();
        }
        return true;
    }

    public int radius(int height, int maxHeight) {
        float x = (float)height / (float)maxHeight;
        float maxRadius = 1.0f + (float)maxHeight * 0.1f;
        float r = maxRadius * 0.6667f * x * (1.0f / (x * x + 0.08173f) - 0.9244f);
        return (int)(r + 0.5f);
    }

    public boolean checkSpace(class_1936 world, class_2338 pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = y <= baseHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos1 = pos.method_10069(x, y, z);
                    if (pos1.method_10264() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(class_1936 world, class_2338 pos, int radius, class_4647.class_8179 leaves, CypressTreeConfiguration config) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (radius < 2) {
                    if (x * x + z * z > radius * radius) continue;
                    this.placeLeaves(world, pos.method_10069(x, 0, z), leaves, config);
                    continue;
                }
                if ((x == -radius || x == radius) && (z == -radius || z == radius)) continue;
                if (x == -radius || x == radius || z == -radius || z == radius) {
                    if (world.method_8409().method_43048(4) == 0) continue;
                    this.placeLeaves(world, pos.method_10069(x, 0, z), leaves, config);
                    continue;
                }
                this.placeLeaves(world, pos.method_10069(x, 0, z), leaves, config);
            }
        }
    }
}

