/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.net.URI;
import java.util.Collection;
import me.srrapero720.watervision.WaterVision;
import me.srrapero720.watervision.WaterVisionClient;
import me.srrapero720.watervision.common.network.PlayVideoOverlayPacket;
import me.srrapero720.watervision.common.network.PlayVideoPacket;
import me.srrapero720.watervision.common.network.StopVideoOverlayPacket;
import me.srrapero720.watervision.common.network.StopVideoPacket;
import me.srrapero720.watervision.common.network.VisionNetwork;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class VisionCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"playvideo").requires(source -> !source.method_43737() || source.method_9259(4))).then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.25f, (float)2.0f)).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"stretch_video", (ArgumentType)BoolArgumentType.bool()).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"game_fade_duration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"video_fade_duration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(VisionCommands::openVideoScreen)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"allow_controls", (ArgumentType)BoolArgumentType.bool()).executes(VisionCommands::openVideoScreen)).then(class_2170.method_9244((String)"allow_exit", (ArgumentType)BoolArgumentType.bool()).executes(VisionCommands::openVideoScreen)))))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stopvideo").requires(source -> !source.method_43737() || source.method_9259(4))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(VisionCommands::stopVideo)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"playoverlay").requires(source -> !source.method_43737() || source.method_9259(4))).then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(VisionCommands::openVideoOverlay))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stopoverlay").requires(source -> !source.method_43737() || source.method_9259(4))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(VisionCommands::closeVideoOverlay)));
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"playvideoclient").requires(source -> source.getEntity() != null)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.string()).executes(VisionCommands::openVideoScreenClient)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(VisionCommands::openVideoScreenClient)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.25f, (float)2.0f)).executes(VisionCommands::openVideoScreenClient)).then(ClientCommandManager.argument((String)"stretch_video", (ArgumentType)BoolArgumentType.bool()).executes(VisionCommands::openVideoScreenClient))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"playoverlayclient").requires(source -> source.getEntity() != null)).then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.string()).executes(VisionCommands::openVideoOverlayClient)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"stopoverlayclient").requires(source -> source.getEntity() != null)).executes(VisionCommands::closeVideoOverlayClient));
    }

    @Environment(value=EnvType.CLIENT)
    private static int openVideoScreenClient(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        try {
            String url = StringArgumentType.getString(context, (String)"url");
            int volume = VisionCommands.getIntOrDefaultClient(context, "volume", 100);
            float speed = VisionCommands.getFloatOrDefaultClient(context, "speed", 1.0f);
            boolean stretchVideo = VisionCommands.getBoolOrDefaultClient(context, "stretch_video", false);
            new Thread(() -> {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                class_310.method_1551().execute(() -> WaterVisionClient.openScreen(URI.create(url), volume, speed, stretchVideo, 20.0f, 20.0f, true, true));
            }).start();
            return 0;
        }
        catch (Exception e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Failed to open video screen, see log for more details"));
            WaterVision.LOGGER.error("Failed to execute /playvideoclient command", (Throwable)e);
            return 1;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static int openVideoOverlayClient(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        try {
            String url = StringArgumentType.getString(context, (String)"url");
            WaterVisionClient.openOverlay(URI.create(url));
            return 0;
        }
        catch (Throwable e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static int closeVideoOverlayClient(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        try {
            WaterVisionClient.closeOverlay();
            return 0;
        }
        catch (Exception e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static int openVideoScreen(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String url = StringArgumentType.getString(context, (String)"url");
            Collection players = class_2186.method_9312(context, (String)"target");
            int volume = VisionCommands.getIntOrDefault(context, "volume", 100);
            float speed = VisionCommands.getFloatOrDefault(context, "speed", 1.0f);
            boolean stretchVideo = VisionCommands.getBoolOrDefault(context, "stretch_video", false);
            float gameFadeDuration = VisionCommands.getFloatOrDefault(context, "game_fade_duration", 20.0f);
            float videoFadeDuration = VisionCommands.getFloatOrDefault(context, "video_fade_duration", 20.0f);
            boolean allowControls = VisionCommands.getBoolOrDefault(context, "allow_controls", true);
            boolean exit = VisionCommands.getBoolOrDefault(context, "allow_exit", true);
            for (class_3222 player : players) {
                WaterVision.LOGGER.info("Opening videoscreen for {}", (Object)player.method_5477().getString());
                VisionNetwork.sendTo(new PlayVideoPacket(url, volume, speed, stretchVideo, gameFadeDuration, videoFadeDuration, allowControls, exit), player);
            }
            return 0;
        }
        catch (Throwable e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playvideo command", e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static int openVideoOverlay(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String url = StringArgumentType.getString(context, (String)"url");
            Collection players = class_2186.method_9312(context, (String)"target");
            for (class_3222 player : players) {
                VisionNetwork.sendTo(new PlayVideoOverlayPacket(url), player);
            }
            return 0;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static int closeVideoOverlay(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            Collection players = class_2186.method_9312(context, (String)"target");
            for (class_3222 player : players) {
                VisionNetwork.sendTo(new StopVideoOverlayPacket(), player);
            }
            return 0;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static int stopVideo(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            Collection players = class_2186.method_9312(context, (String)"target");
            for (class_3222 player : players) {
                VisionNetwork.sendTo(new StopVideoPacket(), player);
            }
            return 0;
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to open video screen, see console for more details"));
            WaterVision.LOGGER.error("Failed to execute /playoverlay command", (Throwable)e);
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            return 1;
        }
    }

    private static String getStringOrDefault(CommandContext<class_2168> context, String name, String def) {
        try {
            return StringArgumentType.getString(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static int getIntOrDefault(CommandContext<class_2168> context, String name, int def) {
        try {
            return IntegerArgumentType.getInteger(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static float getFloatOrDefault(CommandContext<class_2168> context, String name, float def) {
        try {
            return FloatArgumentType.getFloat(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static boolean getBoolOrDefault(CommandContext<class_2168> context, String name, boolean def) {
        try {
            return BoolArgumentType.getBool(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static String getStringOrDefaultClient(CommandContext<FabricClientCommandSource> context, String name, String def) {
        try {
            return StringArgumentType.getString(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static int getIntOrDefaultClient(CommandContext<FabricClientCommandSource> context, String name, int def) {
        try {
            return IntegerArgumentType.getInteger(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static float getFloatOrDefaultClient(CommandContext<FabricClientCommandSource> context, String name, float def) {
        try {
            return FloatArgumentType.getFloat(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }

    private static boolean getBoolOrDefaultClient(CommandContext<FabricClientCommandSource> context, String name, boolean def) {
        try {
            return BoolArgumentType.getBool(context, (String)name);
        }
        catch (IllegalArgumentException ex) {
            return def;
        }
    }
}

