/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision.client.screens.widgets;

import net.minecraft.class_332;
import org.watermedia.api.math.MathAPI;

public class FadeBackground {
    private float fadeTick = 0.0f;
    private final float fadeTickDuration;

    public FadeBackground(float duration) {
        this.fadeTickDuration = Math.max(0.01f, duration);
    }

    public void render(class_332 graphics, int width, int height, boolean fadeIn, float partialTicks) {
        if (fadeIn) {
            if (this.fadeTick < this.fadeTickDuration) {
                this.fadeTick += partialTicks;
            }
            if (this.fadeTick > this.fadeTickDuration) {
                this.fadeTick = this.fadeTickDuration;
            }
        } else {
            if (this.fadeTick > 0.0f) {
                this.fadeTick -= partialTicks;
            }
            if (this.fadeTick < 0.0f) {
                this.fadeTick = 0.0f;
            }
        }
        int alpha = (int)MathAPI.easeIn((double)0.0, (double)255.0, (double)MathAPI.scaleTempo((double)0.0, (double)this.fadeTickDuration, (double)this.fadeTick));
        graphics.method_25294(0, 0, width, height, MathAPI.argb((int)alpha, (int)0, (int)0, (int)0));
    }

    public boolean isFadedOut() {
        return this.fadeTick <= 0.0f;
    }

    public boolean isFadedIn() {
        return this.fadeTick >= this.fadeTickDuration;
    }

    public void forceFadeOut() {
        this.fadeTick = 0.0f;
    }

    public void forceFadeIn() {
        this.fadeTick = this.fadeTickDuration;
    }
}

