/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision.client.screens;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import me.srrapero720.watervision.WaterVision;
import me.srrapero720.watervision.WaterVisionClient;
import me.srrapero720.watervision.client.render.TextureWrapper;
import me.srrapero720.watervision.client.screens.widgets.FadeBackground;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.watermedia.api.player.PlayerAPI;
import org.watermedia.api.player.videolan.VideoPlayer;

public class VisionScreen
extends class_437 {
    private static final DateFormat FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final class_2960 TEXTURE = class_2960.method_43902((String)"watervision", (String)"video_texture");
    private final boolean stretch;
    private final boolean controls;
    private final boolean exit;
    private final VideoPlayer videoPlayer;
    private final TextureWrapper textureWrapper;
    private Status status = Status.OPENING_GAME;
    private final FadeBackground gameBackground;
    private final FadeBackground videoBackground;

    public VisionScreen(URI uri, int volume, float speed, boolean stretch, float gameFadeDuration, float videoFadeDuration, boolean controls, boolean exit) {
        super((class_2561)class_2561.method_43470((String)"WaterVision"));
        this.stretch = stretch;
        this.controls = controls;
        this.exit = exit;
        this.gameBackground = new FadeBackground(gameFadeDuration);
        this.videoBackground = new FadeBackground(videoFadeDuration);
        this.videoBackground.forceFadeIn();
        this.videoPlayer = new VideoPlayer(PlayerAPI.getFactory(), (Executor)class_310.method_1551());
        this.videoPlayer.setVolume(class_3532.method_15340((int)volume, (int)0, (int)100));
        this.videoPlayer.setSpeed(class_3532.method_15363((float)speed, (float)0.1f, (float)3.0f));
        this.textureWrapper = new TextureWrapper(this.videoPlayer.texture());
        class_310.method_1551().method_1531().method_4616(TEXTURE, (class_1044)this.textureWrapper);
        this.videoPlayer.startPaused(uri);
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float partialTick) {
        this.gameBackground.render(guiGraphics, this.field_22789, this.field_22790, this.status != Status.CLOSING_GAME, partialTick);
        if (this.status == Status.OPENING_VIDEO || this.status == Status.CLOSING_VIDEO) {
            this.videoPlayer.preRender();
            if (this.stretch) {
                WaterVisionClient.internal$blit(guiGraphics, TEXTURE, 1.0f, 0, 0, 0, 0, this.field_22789, this.field_22790);
            } else {
                AspectRatioDimension dim = this.render$getAspectRatio(this.field_22789, this.field_22790, this.videoPlayer.width(), this.videoPlayer.height());
                WaterVisionClient.internal$blit(guiGraphics, TEXTURE, 1.0f, dim.x, dim.y, 0, 0, dim.width, dim.height);
            }
        }
        if (this.status != Status.OPENING_GAME && this.status != Status.CLOSING_GAME) {
            this.videoBackground.render(guiGraphics, this.field_22789, this.field_22790, this.status == Status.CLOSING_VIDEO, partialTick);
        }
        if (this.status == Status.OPENING_GAME || this.status == Status.CLOSING_VIDEO || this.status == Status.CLOSING_GAME || this.videoPlayer.isBuffering() || this.videoPlayer.isLoading()) {
            this.render$loadingIcon(guiGraphics, partialTick);
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            if (!this.videoPlayer.isSafeUse()) {
                return;
            }
            guiGraphics.method_25303(this.field_22793, String.format("State: %s", this.videoPlayer.getStateName()), 0, this.field_22790 / 2 - 12, 0xFFFFFF);
            guiGraphics.method_25303(this.field_22793, String.format("Time: %s (%s) / %s (%s)", FORMAT.format(new Date(this.videoPlayer.getTime())), this.videoPlayer.getTime(), FORMAT.format(new Date(this.videoPlayer.getDuration())), this.videoPlayer.getDuration()), 0, this.field_22790 / 2, 0xFFFFFF);
            guiGraphics.method_25303(this.field_22793, String.format("Media Duration: %s (%s)", FORMAT.format(new Date(this.videoPlayer.getMediaInfoDuration())), this.videoPlayer.getMediaInfoDuration()), 0, this.field_22790 / 2 + 12, 0xFFFFFF);
            guiGraphics.method_25303(this.field_22793, String.format("Orchestrator Status: %s", this.status.name()), 0, this.field_22790 / 2 + 24, 0xFFFFFF);
            guiGraphics.method_25303(this.field_22793, String.format("Video Size: %sx%s", this.videoPlayer.width(), this.videoPlayer.height()), 0, this.field_22790 / 2 + 36, 0xFFFFFF);
        }
    }

    private void render$loadingIcon(class_332 graphics, float partialTick) {
        WaterVisionClient.internal$blit(graphics, WaterVision.LOADING_ANIM_TEXTURE, 1.0f, this.field_22789 - 40, this.field_22790 - 40, 0, 0, 40, 40);
    }

    private AspectRatioDimension render$getAspectRatio(int screenWidth, int screenHeight, int videoWidth, int videoHeight) {
        int renderHeight;
        int renderWidth;
        float videoAspectRatio = (float)videoWidth / (float)videoHeight;
        float containerAspectRatio = (float)screenWidth / (float)screenHeight;
        if (videoAspectRatio > containerAspectRatio) {
            renderWidth = screenWidth;
            renderHeight = (int)((float)screenWidth / videoAspectRatio);
        } else {
            renderWidth = (int)((float)screenHeight * videoAspectRatio);
            renderHeight = screenHeight;
        }
        int offsetX = (screenWidth - renderWidth) / 2;
        int offsetY = (screenHeight - renderHeight) / 2;
        return new AspectRatioDimension(offsetX, offsetY, renderWidth, renderHeight);
    }

    public void method_25420(class_332 guiGraphics) {
    }

    public void method_25393() {
        switch (this.status) {
            case OPENING_GAME: {
                if (!this.gameBackground.isFadedIn() || !this.videoPlayer.isSafeUse() || !this.videoPlayer.isReady()) break;
                this.status = Status.OPENING_VIDEO;
                this.videoPlayer.play();
                break;
            }
            case OPENING_VIDEO: {
                if (!this.videoBackground.isFadedOut() || !this.videoPlayer.isEnded() && !this.videoPlayer.isStopped() && !this.videoPlayer.isBroken()) break;
                this.status = Status.CLOSING_VIDEO;
                break;
            }
            case CLOSING_VIDEO: {
                if (!this.videoBackground.isFadedIn()) break;
                this.status = Status.CLOSING_GAME;
                break;
            }
            case CLOSING_GAME: {
                if (!this.gameBackground.isFadedOut()) break;
                this.method_25419();
            }
        }
    }

    public boolean method_25422() {
        return this.exit;
    }

    public void method_25419() {
        if (this.videoPlayer.isSafeUse() && this.videoPlayer.isPlaying()) {
            this.videoPlayer.stop();
            return;
        }
        if (this.status != Status.CLOSING_GAME) {
            return;
        }
        class_310.method_1551().method_1483().method_4880();
        this.videoPlayer.release();
        super.method_25419();
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
    }

    public static enum Status {
        OPENING_GAME,
        OPENING_VIDEO,
        CLOSING_VIDEO,
        CLOSING_GAME;

    }

    public record AspectRatioDimension(int x, int y, int width, int height) {
    }
}

