/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.CommandDispatcher;
import java.net.URI;
import me.srrapero720.watervision.VisionOverlay;
import me.srrapero720.watervision.WaterVision;
import me.srrapero720.watervision.client.render.TextureWrapper;
import me.srrapero720.watervision.client.screens.VisionScreen;
import me.srrapero720.watervision.common.commands.VisionCommands;
import me.srrapero720.watervision.common.network.VisionNetwork;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1044;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.watermedia.api.image.ImageAPI;

public class WaterVisionClient
implements ClientModInitializer {
    public static final int DEF_VOLUME = 100;
    public static final float DEF_SPEED = 1.0f;
    public static final boolean DEF_STRETCH = false;
    public static final float DEF_GAME_FADE_DURATION = 20.0f;
    public static final float DEF_VIDEO_FADE_DURATION = 20.0f;
    public static final boolean DEF_CONTROLS = true;
    public static final boolean DEF_EXIT = true;

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> client.method_1531().method_4616(WaterVision.LOADING_ANIM_TEXTURE, (class_1044)new TextureWrapper.Renderer(ImageAPI.loadingGif((String)"watervision"))));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (WaterVision.ticks == Integer.MAX_VALUE) {
                WaterVision.ticks = 0;
            }
            ++WaterVision.ticks;
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> VisionCommands.registerClient((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        VisionNetwork.initClient();
    }

    @Environment(value=EnvType.CLIENT)
    public static void openScreen(URI uri, int volume, float speed, boolean stretchVideo, float gameFadeDuration, float videoFadeDuration, boolean controls, boolean exit) {
        class_310.method_1551().method_1507((class_437)new VisionScreen(uri, volume, speed, stretchVideo, gameFadeDuration, videoFadeDuration, controls, exit));
    }

    @Environment(value=EnvType.CLIENT)
    public static void closeScreen() {
        if (class_310.method_1551().field_1755 instanceof VisionScreen) {
            class_310.method_1551().method_1507(null);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void openOverlay(URI uri) {
        VisionOverlay.uri = uri;
    }

    @Environment(value=EnvType.CLIENT)
    public static void closeOverlay() {
        VisionOverlay.uri = null;
    }

    @Environment(value=EnvType.CLIENT)
    public static void internal$blit(class_332 graphics, class_2960 texture, float alpha, int x, int y, int offsetX, int offsetY, int width, int height) {
        float pX1 = x;
        float pX2 = x + width;
        float pY1 = y;
        float pY2 = y + height;
        float pBlitOffset = 0.0f;
        int pMinU = offsetX / width;
        int pMaxU = (offsetX + width) / width;
        int pMinV = offsetY / height;
        int pMaxV = (offsetY + height) / height;
        RenderSystem.enableBlend();
        int tex = class_310.method_1551().method_1531().method_4619(texture).method_4624();
        RenderSystem.bindTexture((int)tex);
        RenderSystem.setShaderTexture((int)0, (int)tex);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(matrix4f, pX1, pY1, 0.0f).method_22913((float)pMinU, (float)pMinV).method_1344();
        bufferbuilder.method_22918(matrix4f, pX1, pY2, 0.0f).method_22913((float)pMinU, (float)pMaxV).method_1344();
        bufferbuilder.method_22918(matrix4f, pX2, pY2, 0.0f).method_22913((float)pMaxU, (float)pMaxV).method_1344();
        bufferbuilder.method_22918(matrix4f, pX2, pY1, 0.0f).method_22913((float)pMaxU, (float)pMinV).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        RenderSystem.disableBlend();
    }
}

