/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.utils;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IngredientMap<T> {
    private final Map<IIngredient, Map<IngredientMapEntry<T>, T>> internal = new HashMap<IIngredient, Map<IngredientMapEntry<T>, T>>();

    public List<T> getEntries(IItemStack item) {
        ArrayList<T> entries = new ArrayList<T>();
        for (IIngredient ingredient : this.internal.keySet()) {
            if (!ingredient.matches(item)) continue;
            entries.addAll(this.internal.get(ingredient).values());
        }
        return entries;
    }

    public void unregister(IngredientMapEntry<T> entry) {
        this.internal.forEach((ingredient, ingredientMapEntryTMap) -> ingredientMapEntryTMap.remove(entry));
    }

    public IngredientMapEntry<T> register(IIngredient ingredient, T entry) {
        this.internal.computeIfAbsent(ingredient, k -> new HashMap());
        IngredientMapEntry mapEntry = new IngredientMapEntry();
        this.internal.get(ingredient).put(mapEntry, entry);
        return mapEntry;
    }

    public static class IngredientMapEntry<T> {
    }
}

