/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.displayslot;

import io.bluebeaker.backpackdisplay.BackpackDisplayMod;
import io.bluebeaker.backpackdisplay.displayslot.DisplaySlotEntryBase;
import io.bluebeaker.backpackdisplay.displayslot.ValueOperation;
import io.bluebeaker.backpackdisplay.utils.ItemUtils;
import io.bluebeaker.backpackdisplay.utils.NBTUtils;
import io.bluebeaker.backpackdisplay.utils.ValueOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;

public class DisplaySlotEntrySingle
extends DisplaySlotEntryBase {
    String[] pathToItem = new String[0];
    String[] pathToCount = new String[0];
    List<ValueOperation> operations = Collections.emptyList();

    public DisplaySlotEntrySingle(String nbtRule) {
        super(nbtRule);
        String[] splitted = nbtRule.split("(?<!\\\\);", 3);
        this.pathToItem = NBTUtils.getKeysList(splitted[0]);
        if (splitted.length >= 2) {
            this.pathToCount = NBTUtils.getKeysList(splitted[1]);
        }
        if (splitted.length >= 3) {
            this.operations = new ArrayList<ValueOperation>();
            for (String path : splitted[2].split("(?<!\\\\);", 0)) {
                ValueOperation newOperation = new ValueOperation(path);
                if (newOperation.operator instanceof ValueOperator.NUL) {
                    BackpackDisplayMod.logError("Error parsing operation +'" + path + "'");
                    continue;
                }
                this.operations.add(newOperation);
            }
        }
    }

    @Override
    public List<class_1799> getItemsFromContainer(class_1799 stack) {
        class_1799 newStack;
        ArrayList<class_1799> output = new ArrayList<class_1799>();
        class_2487 rootNBT = stack.method_7969();
        class_2520 itemTag = NBTUtils.getTagRecursive((class_2520)rootNBT, this.pathToItem);
        if (itemTag instanceof class_2487 && !(newStack = ItemUtils.createStackFromNBT((class_2487)itemTag)).method_7960()) {
            class_2520 countTag;
            if (this.pathToCount.length > 0 && (countTag = NBTUtils.getTagRecursive((class_2520)rootNBT, this.pathToCount)) != null && NBTUtils.isNumber(countTag)) {
                int count = ((class_2514)countTag).method_10701();
                for (ValueOperation operation : this.operations) {
                    count = operation.doOperation(count, rootNBT);
                }
                newStack.method_7939(count);
            }
            output.add(newStack);
        }
        return output;
    }
}

