/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.backpackdisplay.displayslot;

import io.bluebeaker.backpackdisplay.displayslot.DisplaySlotEntryBase;
import io.bluebeaker.backpackdisplay.utils.ComparatorWithNumbers;
import io.bluebeaker.backpackdisplay.utils.ItemUtils;
import io.bluebeaker.backpackdisplay.utils.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class DisplaySlotEntryList
extends DisplaySlotEntryBase {
    String[] pathToList = new String[0];
    String[] pathToItem = new String[0];
    String[] pathToCount = new String[0];

    public DisplaySlotEntryList(String nbtRule) {
        super(nbtRule);
        String[] splitted = nbtRule.split("(?<!\\\\);");
        this.pathToList = NBTUtils.getKeysList(splitted[0]);
        if (splitted.length >= 2) {
            this.pathToItem = NBTUtils.getKeysList(splitted[1]);
        }
        if (splitted.length >= 3) {
            this.pathToCount = NBTUtils.getKeysList(splitted[2]);
        }
    }

    @Override
    public List<class_1799> getItemsFromContainer(class_1799 stack) {
        ArrayList<class_1799> output;
        block3: {
            class_2520 listRoot;
            block2: {
                output = new ArrayList<class_1799>();
                listRoot = NBTUtils.getTagRecursive((class_2520)stack.method_7969(), this.pathToList);
                if (!(listRoot instanceof class_2499)) break block2;
                class_2499 list = (class_2499)listRoot;
                for (class_2520 tag : list) {
                    class_1799 newStack = this.getSingleItem(tag);
                    if (newStack == null || newStack.method_7960()) continue;
                    output.add(newStack);
                }
                break block3;
            }
            if (!(listRoot instanceof class_2487)) break block3;
            class_2487 comp = (class_2487)listRoot;
            Set keys = comp.method_10541();
            List sortedKeys = keys.stream().sorted(new ComparatorWithNumbers()).collect(Collectors.toList());
            for (String key : sortedKeys) {
                class_2520 tag = comp.method_10580(key);
                class_1799 newStack = this.getSingleItem(tag);
                if (newStack == null || newStack.method_7960()) continue;
                output.add(newStack);
            }
        }
        return output;
    }

    @Nullable
    private class_1799 getSingleItem(class_2520 tag) {
        class_1799 newStack;
        class_2520 itemTag = NBTUtils.getTagRecursive(tag, this.pathToItem);
        if (itemTag instanceof class_2487 && !(newStack = ItemUtils.createStackFromNBT((class_2487)itemTag)).method_7960()) {
            class_2520 countTag;
            if (this.pathToCount.length > 0 && (countTag = NBTUtils.getTagRecursive(tag, this.pathToCount)) instanceof class_2514) {
                newStack.method_7939(((class_2514)countTag).method_10701());
            }
            return newStack;
        }
        return null;
    }
}

