/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.util;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class NinePatchTexture {
    private final class_2960 textureId;
    private final int textureWidth;
    private final int textureHeight;
    private final int leftWidth;
    private final int rightWidth;
    private final int topHeight;
    private final int bottomHeight;
    private final boolean tiling;
    private final int tileWidth;
    private final int tileHeight;
    private final int leftRight;
    private final int topBottom;
    private final float pieceU1;
    private final float pieceV1;
    private final float pieceU2;
    private final float pieceV2;
    private final float leftRightU;
    private final float rightLeftU;
    private final float topBottomV;
    private final float bottomTopV;

    public NinePatchTexture(class_2960 textureId, int u, int v, int width, int height, int leftWidth, int rightWidth, int topHeight, int bottomHeight, boolean tiling) {
        this(textureId, 256, 256, u, v, width, height, leftWidth, rightWidth, topHeight, bottomHeight, tiling);
    }

    public NinePatchTexture(class_2960 textureId, int textureWidth, int textureHeight, int u, int v, int width, int height, int leftWidth, int rightWidth, int topHeight, int bottomHeight, boolean tiling) {
        this.textureId = textureId;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.leftWidth = leftWidth;
        this.rightWidth = rightWidth;
        this.topHeight = topHeight;
        this.bottomHeight = bottomHeight;
        this.tiling = tiling;
        int endX = u + width;
        int endY = v + height;
        this.tileWidth = width - leftWidth - rightWidth;
        this.tileHeight = height - topHeight - bottomHeight;
        if (this.tileWidth < 1) {
            throw new IllegalArgumentException("leftWidth + rightWidth must be less than pieceWidth");
        }
        if (this.tileHeight < 1) {
            throw new IllegalArgumentException("topHeight + bottomHeight must be less than pieceHeight");
        }
        this.leftRight = u + leftWidth;
        this.topBottom = v + topHeight;
        this.pieceU1 = (float)u / (float)textureWidth;
        this.pieceV1 = (float)v / (float)textureHeight;
        this.pieceU2 = (float)endX / (float)textureWidth;
        this.pieceV2 = (float)endY / (float)textureHeight;
        this.leftRightU = (float)(u + leftWidth) / (float)textureWidth;
        this.rightLeftU = (float)(endX - rightWidth) / (float)textureWidth;
        this.topBottomV = (float)(v + topHeight) / (float)textureHeight;
        this.bottomTopV = (float)(endY - bottomHeight) / (float)textureHeight;
    }

    public void render(class_4587 stack, int x, int y, int w, int h) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.textureId);
        RenderSystem.setShader(class_757::method_34542);
        class_289 tess = class_289.method_1348();
        class_287 bufferBuilder = tess.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        this.render((class_4588)bufferBuilder, stack.method_23760().method_23761(), 0, x, y, w, h);
        tess.method_1350();
    }

    private void render(class_4588 consumer, Matrix4f mat, int z, int x, int y, int w, int h) {
        int centerWidth = w - this.leftWidth - this.rightWidth;
        int centerHeight = h - this.topHeight - this.bottomHeight;
        int rightLeft = x + w - this.rightWidth;
        int bottomTop = y + h - this.bottomHeight;
        NinePatchTexture.rect(consumer, mat, z, x, y, this.leftWidth, this.topHeight, this.pieceU1, this.pieceV1, this.leftRightU, this.topBottomV);
        NinePatchTexture.rect(consumer, mat, z, rightLeft, y, this.rightWidth, this.topHeight, this.rightLeftU, this.pieceV1, this.pieceU2, this.topBottomV);
        NinePatchTexture.rect(consumer, mat, z, x, bottomTop, this.leftWidth, this.bottomHeight, this.pieceU1, this.bottomTopV, this.leftRightU, this.pieceV2);
        NinePatchTexture.rect(consumer, mat, z, rightLeft, bottomTop, this.rightWidth, this.bottomHeight, this.rightLeftU, this.bottomTopV, this.pieceU2, this.pieceV2);
        if (this.tiling) {
            int tilesX = (centerWidth + this.tileWidth - 1) / this.tileWidth;
            int tilesY = (centerHeight + this.tileHeight - 1) / this.tileHeight;
            for (int tileXIndex = 0; tileXIndex < tilesX; ++tileXIndex) {
                int localTileX = tileXIndex * this.tileWidth;
                int curTileWidth = Math.min(this.tileWidth, centerWidth - localTileX);
                float curTileU2 = (float)(this.leftRight + curTileWidth) / (float)this.textureWidth;
                NinePatchTexture.rect(consumer, mat, z, this.leftWidth + localTileX + x, y, curTileWidth, this.topHeight, this.leftRightU, this.pieceV1, curTileU2, this.topBottomV);
                NinePatchTexture.rect(consumer, mat, z, this.leftWidth + localTileX + x, bottomTop, curTileWidth, this.bottomHeight, this.leftRightU, this.bottomTopV, curTileU2, this.pieceV2);
            }
            for (int tileYIndex = 0; tileYIndex < tilesY; ++tileYIndex) {
                int localTileY = tileYIndex * this.tileHeight;
                int curTileHeight = Math.min(this.tileHeight, centerHeight - localTileY);
                float curTileV2 = (float)(this.topBottom + curTileHeight) / (float)this.textureHeight;
                NinePatchTexture.rect(consumer, mat, z, x, this.topHeight + localTileY + y, this.leftWidth, curTileHeight, this.pieceU1, this.topBottomV, this.leftRightU, curTileV2);
                NinePatchTexture.rect(consumer, mat, z, rightLeft, this.topHeight + localTileY + y, this.rightWidth, curTileHeight, this.rightLeftU, this.topBottomV, this.pieceU2, curTileV2);
                for (int tileXIndex = 0; tileXIndex < tilesX; ++tileXIndex) {
                    int localTileX = tileXIndex * this.tileWidth;
                    int curTileWidth = Math.min(this.tileWidth, centerWidth - localTileX);
                    float curTileU2 = (float)(this.leftRight + curTileWidth) / (float)this.textureWidth;
                    NinePatchTexture.rect(consumer, mat, z, this.leftWidth + localTileX + x, this.topHeight + localTileY + y, curTileWidth, curTileHeight, this.leftRightU, this.topBottomV, curTileU2, curTileV2);
                }
            }
        } else {
            if (centerWidth > 0) {
                NinePatchTexture.rect(consumer, mat, z, this.leftWidth + x, y, centerWidth, this.topHeight, this.leftRightU, this.pieceV1, this.rightLeftU, this.topBottomV);
                NinePatchTexture.rect(consumer, mat, z, this.leftWidth + x, bottomTop, centerWidth, this.bottomHeight, this.leftRightU, this.bottomTopV, this.rightLeftU, this.pieceV2);
            }
            if (centerHeight > 0) {
                NinePatchTexture.rect(consumer, mat, z, x, this.topHeight + y, this.leftWidth, centerHeight, this.pieceU1, this.topBottomV, this.leftRightU, this.bottomTopV);
                NinePatchTexture.rect(consumer, mat, z, rightLeft, this.topHeight + y, this.rightWidth, centerHeight, this.rightLeftU, this.topBottomV, this.pieceU2, this.bottomTopV);
                if (centerWidth > 0) {
                    NinePatchTexture.rect(consumer, mat, z, this.leftWidth + x, this.topHeight + y, centerWidth, centerHeight, this.leftRightU, this.topBottomV, this.rightLeftU, this.bottomTopV);
                }
            }
        }
    }

    private static void rect(class_4588 consumer, Matrix4f mat, int z, int x0, int y0, int w, int h, float u0, float v0, float u1, float v1) {
        int x1 = x0 + w;
        int y1 = y0 + h;
        consumer.method_22918(mat, (float)x0, (float)y1, (float)z).method_22913(u0, v1).method_1344();
        consumer.method_22918(mat, (float)x1, (float)y1, (float)z).method_22913(u1, v1).method_1344();
        consumer.method_22918(mat, (float)x1, (float)y0, (float)z).method_22913(u1, v0).method_1344();
        consumer.method_22918(mat, (float)x0, (float)y0, (float)z).method_22913(u0, v0).method_1344();
    }
}

