/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.indrev;

import com.kneelawk.extramodintegrations.ExMIMod;
import com.kneelawk.extramodintegrations.util.LongHolder;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.steven.indrev.recipes.machines.IRFluidRecipe;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IRFluidEmiRecipe<R extends IRFluidRecipe>
implements EmiRecipe {
    protected final R recipe;
    protected final class_2960 id;
    protected final List<EmiIngredient> inputs;
    protected final List<EmiIngredient> inputItems;
    protected final List<EmiStack> outputs;
    protected final List<EmiStack> outputItems;
    protected final LongHolder capacityHolder;

    protected IRFluidEmiRecipe(R recipe, LongHolder capacityHolder) {
        this.recipe = recipe;
        this.id = recipe.getIdentifier();
        this.inputItems = Arrays.stream(recipe.getInput()).map(entry -> EmiIngredient.of((class_1856)entry.getIngredient(), (long)entry.getCount())).toList();
        this.inputs = Stream.concat(this.inputItems.stream(), Arrays.stream(recipe.getFluidInput()).map(res -> EmiStack.of((class_3611)((FluidVariant)res.resource()).getFluid(), (class_2487)((FluidVariant)res.resource()).getNbt(), (long)res.amount()))).toList();
        this.outputItems = Arrays.stream(recipe.getOutputs()).map(entry -> EmiStack.of((class_1799)entry.getStack()).setChance((float)entry.getChance())).toList();
        this.outputs = Stream.concat(this.outputItems.stream(), Arrays.stream(recipe.getFluidOutput()).map(res -> EmiStack.of((class_3611)((FluidVariant)res.resource()).getFluid(), (class_2487)((FluidVariant)res.resource()).getNbt(), (long)res.amount()))).toList();
        this.capacityHolder = capacityHolder;
        this.maxFluidVolumes(capacityHolder);
    }

    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    protected final void checkInputCount(int count) {
        if (this.inputs.size() != count) {
            ExMIMod.LOGGER.warn("Expected recipe {} ({}) to have {} inputs but instead it has {}", new Object[]{this.id, this.recipe, count, this.inputs.size()});
        }
    }

    protected final void checkOutputCount(int count) {
        if (this.outputs.size() != count) {
            ExMIMod.LOGGER.warn("Expected recipe {} ({}) to have {} outputs but instead it has {}", new Object[]{this.id, this.recipe, count, this.outputs.size()});
        }
    }

    protected EmiIngredient getInput(int index) {
        if (index >= this.inputs.size()) {
            return EmiStack.EMPTY;
        }
        return this.inputs.get(index);
    }

    @Nullable
    protected ResourceAmount<FluidVariant> getInputFluid(int index) {
        ResourceAmount[] fluidInputs = this.recipe.getFluidInput();
        if (index >= fluidInputs.length) {
            return null;
        }
        return fluidInputs[index];
    }

    protected EmiIngredient getInputItem(int index) {
        if (index >= this.inputItems.size()) {
            return EmiStack.EMPTY;
        }
        return this.inputs.get(index);
    }

    protected EmiStack getOutput(int index) {
        if (index >= this.outputs.size()) {
            return EmiStack.EMPTY;
        }
        return this.outputs.get(index);
    }

    @Nullable
    protected ResourceAmount<FluidVariant> getOutputFluid(int index) {
        ResourceAmount[] fluidOutputs = this.recipe.getFluidOutput();
        if (index >= fluidOutputs.length) {
            return null;
        }
        return fluidOutputs[index];
    }

    protected EmiStack getOutputItem(int index) {
        if (index >= this.outputItems.size()) {
            return EmiStack.EMPTY;
        }
        return this.outputItems.get(index);
    }

    protected long getSlotCapacity() {
        return this.capacityHolder.getValue();
    }

    private IRFluidEmiRecipe<R> maxFluidVolumes(LongHolder volumeHolder) {
        ResourceAmount fluid;
        int i;
        ResourceAmount[] fluidInputs = this.recipe.getFluidInput();
        ResourceAmount[] fluidOutputs = this.recipe.getFluidOutput();
        long fluidVolume = volumeHolder.getValue();
        for (i = 0; i < fluidInputs.length; ++i) {
            fluid = fluidInputs[i];
            if (fluid.amount() <= fluidVolume) continue;
            fluidVolume = fluid.amount();
        }
        for (i = 0; i < fluidOutputs.length; ++i) {
            fluid = fluidOutputs[i];
            if (fluid.amount() <= fluidVolume) continue;
            fluidVolume = fluid.amount();
        }
        if (fluidVolume > volumeHolder.getValue()) {
            volumeHolder.setValue(fluidVolume);
        }
        return this;
    }
}

