/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamMessage;
import dev.ftb.mods.ftbteams.client.gui.MyTeamScreen;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import dev.ftb.mods.ftbteams.data.TeamMessageImpl;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;

public class SyncMessageHistoryMessage
extends BaseS2CMessage {
    private final List<TeamMessage> messages;

    public SyncMessageHistoryMessage(class_2540 buf) {
        long now = System.currentTimeMillis();
        int nMessages = buf.method_10816();
        this.messages = new ArrayList<TeamMessage>(nMessages);
        for (int i = 0; i < nMessages; ++i) {
            this.messages.add(TeamMessageImpl.fromNetwork(now, buf));
        }
    }

    public SyncMessageHistoryMessage(Team team) {
        this.messages = team.getMessageHistory();
    }

    public MessageType getType() {
        return FTBTeamsNet.SYNC_MESSAGE_HISTORY;
    }

    public void write(class_2540 buf) {
        long now = System.currentTimeMillis();
        buf.method_10804(this.messages.size());
        for (TeamMessage msg : this.messages) {
            TeamMessageImpl.toNetwork(msg, now, buf);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        ClientTeam team = ClientTeamManagerImpl.getInstance().selfTeam();
        if (team != null) {
            team.setMessageHistory(this.messages);
            MyTeamScreen.refreshIfOpen();
        }
    }
}

