/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class KeyValueTask
extends Task {
    public static TaskType TYPE;
    private String key = "key";
    private long value = 100L;

    public KeyValueTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return TYPE;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("key", this.key);
        nbt.method_10544("value", this.value);
    }

    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.key = nbt.method_10558("key");
        this.value = nbt.method_10537("value");
    }

    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.key, Short.MAX_VALUE);
        buffer.method_10791(this.value);
    }

    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.key = buffer.method_10800(Short.MAX_VALUE);
        this.value = buffer.method_10792();
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43469((String)"extraquests.key_value.title", (Object[])new Object[]{this.key, this.value});
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getButtonText() {
        return class_2561.method_43471((String)String.valueOf(this.value));
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("key", this.key, value -> {
            this.key = value;
        }, this.key).setNameKey("extraquests.key_value.key");
        config.addLong("value", this.value, value -> {
            this.value = value;
        }, 100L, 1L, Long.MAX_VALUE).setNameKey("extraquests.key_value.value");
    }

    public void progress(TeamData teamData, String key, long value, boolean ignore) {
        if (this.key.equals(key) && !teamData.isCompleted((QuestObject)this)) {
            if (ignore) {
                teamData.addProgress((Task)this, value);
            } else if (this.checkTaskSequence(teamData) && teamData.canStartTasks(this.getQuest())) {
                teamData.addProgress((Task)this, value);
            }
        }
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public long getValue() {
        return this.value;
    }
}

