/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extraquests.service;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.extraquests.ExtraQuests;
import com.vecoo.extraquests.api.service.ExtraQuestsService;
import com.vecoo.extraquests.service.QuestTimer;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class QuestTimerService {
    @NotNull
    private final transient String filePath;
    @NotNull
    private final Set<QuestTimer> questTimers;
    private volatile transient boolean dirty = false;

    public QuestTimerService(@NotNull String filePath, @NotNull MinecraftServer server) {
        this.filePath = UtilWorld.resolveWorldDirectory((String)filePath, (MinecraftServer)server);
        this.questTimers = new HashSet<QuestTimer>();
    }

    public boolean addQuestTimer(@NotNull QuestTimer questTimer) {
        if (!this.questTimers.add(questTimer)) {
            ExtraQuests.getLogger().error("Failed to add quest timer {}.", (Object)questTimer.questID());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public boolean removeQuestTimer(@NotNull QuestTimer questTimer) {
        if (!this.questTimers.remove(questTimer)) {
            ExtraQuests.getLogger().error("Failed to remove quest timer {}.", (Object)questTimer.questID());
            return false;
        }
        this.dirty = true;
        return true;
    }

    public void save() {
        UtilGson.writeFileAsync((String)this.filePath, (String)"quest_timers.json", (String)UtilGson.getGson().toJson((Object)this)).join();
    }

    private void saveInternal() {
        TaskTimer.builder().withoutDelay().interval(3000L).infinite().consume(task -> {
            if (ExtraQuests.getInstance().getServer().method_3806() && this.dirty) {
                UtilGson.writeFileAsync((String)this.filePath, (String)"quest_timers.json", (String)UtilGson.getGson().toJson((Object)this)).thenRun(() -> {
                    this.dirty = false;
                });
            }
        }).build();
    }

    public void init() {
        this.questTimers.clear();
        UtilGson.readFileAsync((String)this.filePath, (String)"quest_timers.json", el -> {
            QuestTimerService questTimerService = (QuestTimerService)UtilGson.getGson().fromJson(el, QuestTimerService.class);
            long time = System.currentTimeMillis();
            for (QuestTimer questTimer : questTimerService.getQuestTimers()) {
                if (questTimer.endTime() > time) {
                    this.questTimers.add(questTimer);
                    ExtraQuestsService.startQuestTimer(questTimer);
                    continue;
                }
                ExtraQuestsService.questReset(questTimer);
            }
        }).join();
        this.save();
        this.saveInternal();
    }

    @NotNull
    @Generated
    public String getFilePath() {
        return this.filePath;
    }

    @NotNull
    @Generated
    public Set<QuestTimer> getQuestTimers() {
        return this.questTimers;
    }

    @Generated
    public boolean isDirty() {
        return this.dirty;
    }
}

