/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.api.ItemFilterAdapter;
import dev.ftb.mods.ftbquests.client.gui.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.item_filtering.ItemMatchingSystem;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_7417;

public class TaskButton
extends Button {
    private final QuestScreen questScreen;
    Task task;

    public TaskButton(Panel panel, Task task) {
        super(panel, task.getTitle(), Icons.ACCEPT);
        this.questScreen = (QuestScreen)panel.getGui();
        this.task = task;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (this.task.getQuestFile().canEdit() && ScreenWrapper.method_25443()) {
                this.task.onEditButtonClicked((Runnable)((Object)this.questScreen));
            } else {
                boolean canClick = this.task.isValid() && this.questScreen.file.selfTeamData.canStartTasks(this.task.getQuest()) && !this.questScreen.file.selfTeamData.isCompleted(this.task);
                this.task.onButtonClicked(this, canClick);
            }
        } else if (button.isRight() && this.questScreen.file.canEdit()) {
            ItemTask itemTask;
            List tags;
            this.playClickSound();
            ContextMenuBuilder builder = ContextMenuBuilder.create(this.task, this.questScreen);
            Task task = this.task;
            if (task instanceof ItemTask && !(tags = (itemTask = (ItemTask)task).getItemStack().method_7909().method_40131().method_40228().toList()).isEmpty() && !ItemMatchingSystem.INSTANCE.isItemFilter(itemTask.getItemStack())) {
                for (ItemFilterAdapter adapter : ItemMatchingSystem.INSTANCE.adapters()) {
                    if (!adapter.hasItemTagFilter()) continue;
                    builder.insertAtTop(List.of(new ContextMenuItem((class_2561)class_2561.method_43469((String)"ftbquests.task.ftbquests.item.convert_tag", (Object[])new Object[]{adapter.getName()}), (Icon)ThemeProperties.RELOAD_ICON.get(), b -> {
                        if (tags.size() == 1) {
                            this.setTagFilterAndSave(itemTask, adapter, (class_6862<class_1792>)((class_6862)tags.get(0)));
                        } else {
                            new TagSelectionScreen(tags, itemTask, adapter).openGui();
                        }
                    })));
                }
            }
            if ((task = this.task.getIcon()) instanceof ItemIcon) {
                ItemIcon itemIcon = (ItemIcon)task;
                builder.insertAtTop(List.of(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.use_as_quest_icon"), (Icon)ThemeProperties.EDIT_ICON.get(), b -> {
                    this.task.getQuest().setRawIcon(itemIcon.getStack().method_7972());
                    this.task.getQuest().clearCachedData();
                    new EditObjectMessage(this.task.getQuest()).sendToServer();
                })));
            }
            builder.openContextMenu(this.getGui());
        }
    }

    private void setTagFilterAndSave(ItemTask itemTask, ItemFilterAdapter adapter, class_6862<class_1792> tag) {
        itemTask.setStackAndCount(adapter.makeTagFilterStack(tag), itemTask.getItemStack().method_7947());
        if (itemTask.getRawTitle().isEmpty()) {
            itemTask.setRawTitle("Any #" + String.valueOf(tag.comp_327()));
        }
        new EditObjectMessage(itemTask).sendToServer();
    }

    public Optional<PositionedIngredient> getIngredientUnderMouse() {
        return this.task.getIngredient((Widget)this);
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.task);
        this.task.addMouseOverHeader(list, this.questScreen.file.selfTeamData, class_310.method_1551().field_1690.field_1827);
        if (this.questScreen.file.selfTeamData.canStartTasks(this.task.getQuest())) {
            long maxp = this.task.getMaxProgress();
            long progress = this.questScreen.file.selfTeamData.getProgress(this.task);
            if (maxp > 1L) {
                if (this.task.hideProgressNumbers()) {
                    list.add((class_2561)class_2561.method_43470((String)("[" + this.task.getRelativeProgressFromChildren(this.questScreen.file.selfTeamData) + "%]")).method_27692(class_124.field_1077));
                } else {
                    String max = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(maxp) : this.task.formatMaxProgress();
                    String prog = TaskButton.isShiftKeyDown() ? Long.toUnsignedString(progress) : this.task.formatProgress(this.questScreen.file.selfTeamData, progress);
                    String s = (progress > maxp ? max : prog) + " / " + max;
                    if (maxp < 100L) {
                        list.add((class_2561)class_2561.method_43470((String)s).method_27692(class_124.field_1077));
                    } else {
                        list.add((class_2561)class_2561.method_43470((String)s).method_27692(class_124.field_1077).method_10852((class_2561)class_2561.method_43470((String)(" [" + this.task.getRelativeProgressFromChildren(this.questScreen.file.selfTeamData) + "%]")).method_27692(class_124.field_1063)));
                    }
                }
            }
        }
        if (this.task.isOptionalForProgression()) {
            list.add((class_2561)class_2561.method_43471((String)"ftbquests.quest.misc.optional_task").method_27692(class_124.field_1080));
        }
        this.task.addMouseOverText(list, this.questScreen.file.selfTeamData);
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(graphics, theme, x, y, w, h);
        }
    }

    public void drawIcon(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        this.task.drawGUI(this.questScreen.file.selfTeamData, graphics, x, y, w, h);
    }

    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        int bs = h >= 32 ? 32 : 16;
        GuiHelper.setupDrawing();
        this.drawBackground(graphics, theme, x, y, w, h);
        this.drawIcon(graphics, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.questScreen.file.selfTeamData == null) {
            return;
        }
        if (this.questScreen.getContextMenu().isPresent()) {
            // empty if block
        }
        class_4587 poseStack = graphics.method_51448();
        if (this.questScreen.file.selfTeamData.isCompleted(this.task)) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 200.0f);
            RenderSystem.enableBlend();
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(graphics, x + w - 9, y + 1, 8, 8);
            poseStack.method_22909();
        } else {
            class_5250 s = this.task.getButtonText();
            if (s.method_10851() != class_7417.field_39004) {
                poseStack.method_22903();
                poseStack.method_46416((float)x + 19.0f - (float)theme.getStringWidth((class_5348)s) / 2.0f, (float)y + 15.0f, 200.0f);
                poseStack.method_22905(0.5f, 0.5f, 1.0f);
                RenderSystem.enableBlend();
                theme.drawString(graphics, (Object)s, 0, 0, Color4I.WHITE, 2);
                poseStack.method_22909();
            }
        }
    }

    private class TagSelectionScreen
    extends AbstractButtonListScreen {
        private final List<class_6862<class_1792>> tags;
        private final ItemTask itemTask;
        private final ItemFilterAdapter adapter;

        public TagSelectionScreen(List<class_6862<class_1792>> tags, ItemTask itemTask, ItemFilterAdapter adapter) {
            this.itemTask = itemTask;
            this.tags = tags;
            this.adapter = adapter;
            this.setTitle((class_2561)class_2561.method_43471((String)"ftbquests.task.ftbquests.item.select_tag"));
            this.showBottomPanel(false);
            this.showCloseButton(true);
        }

        public void addButtons(Panel panel) {
            this.tags.stream().sorted(Comparator.comparing(itemTagKey -> itemTagKey.comp_327().toString())).forEach(tag -> panel.add((Widget)new TagSelectionButton(panel, (class_6862<class_1792>)tag)));
        }

        public boolean onInit() {
            int titleW = this.getTheme().getStringWidth((class_5348)this.getTitle());
            int w = this.tags.stream().map(t -> this.getTheme().getStringWidth(t.comp_327().toString())).max(Comparator.naturalOrder()).orElse(100);
            this.setSize(Math.max(titleW, w) + 20, this.getScreen().method_4502() * 3 / 4);
            return true;
        }

        protected void doCancel() {
            TaskButton.this.questScreen.openGui();
        }

        protected void doAccept() {
            TaskButton.this.questScreen.openGui();
        }

        private class TagSelectionButton
        extends SimpleTextButton {
            private final class_6862<class_1792> tag;

            public TagSelectionButton(Panel panel, class_6862<class_1792> tag) {
                super(panel, (class_2561)class_2561.method_43470((String)tag.comp_327().toString()), (Icon)Color4I.empty());
                this.tag = tag;
            }

            public void onClicked(MouseButton button) {
                TaskButton.this.questScreen.openGui();
                TaskButton.this.setTagFilterAndSave(TagSelectionScreen.this.itemTask, TagSelectionScreen.this.adapter, this.tag);
            }

            public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                if (this.isMouseOver) {
                    Color4I.WHITE.withAlpha(30).draw(graphics, x, y, w, h);
                }
                Color4I.GRAY.withAlpha(40).draw(graphics, x, y + h, w, 1);
            }
        }
    }
}

