/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;

public class CombinedSlottedStackStorage<S extends SlottedStackStorage>
extends CombinedSlottedStorage<ItemVariant, S>
implements SlottedStackStorage {
    public CombinedSlottedStackStorage(List<S> parts) {
        super(parts);
    }

    @SafeVarargs
    public CombinedSlottedStackStorage(S ... parts) {
        this(List.of(parts));
    }

    private <T> T getFromStorage(int slot, SlotFunction<T> function) {
        for (SlottedStackStorage part : this.parts) {
            if (slot < part.getSlotCount()) {
                return function.apply(part, slot);
            }
            slot -= part.getSlotCount();
        }
        throw new IndexOutOfBoundsException(slot);
    }

    public class_1799 getStackInSlot(int slot) {
        return this.getFromStorage(slot, SlottedStackStorage::getStackInSlot);
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        this.getFromStorage(slot, (storage, index) -> {
            storage.setStackInSlot(index, stack);
            return null;
        });
    }

    public int getSlotLimit(int slot) {
        return this.getFromStorage(slot, SlottedStackStorage::getSlotLimit);
    }

    public boolean isItemValid(int slot, ItemVariant resource, int count) {
        return this.getFromStorage(slot, (storage, index) -> storage.isItemValid(index, resource, count));
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return this.getFromStorage(slot, (storage, index) -> storage.insertSlot(index, resource, maxAmount, transaction));
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return this.getFromStorage(slot, (storage, index) -> storage.extractSlot(index, resource, maxAmount, transaction));
    }

    @FunctionalInterface
    private static interface SlotFunction<T> {
        public T apply(SlottedStackStorage var1, int var2);
    }
}

