/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.cannon;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.schematics.cannon.LaunchedItem;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.fabric.DefaultLayerFilteringBakedModel;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.EmptyVirtualBlockGetter;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.BlockRenderDispatcherAccessor;
import io.github.fabricators_of_create.porting_lib.models.virtual.FixedLightBakedModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_811;

public class SchematicannonRenderer
extends SafeBlockEntityRenderer<SchematicannonBlockEntity> {
    public SchematicannonRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(SchematicannonBlockEntity blockEntity, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        boolean blocksLaunching;
        boolean bl = blocksLaunching = !blockEntity.flyingBlocks.isEmpty();
        if (blocksLaunching) {
            SchematicannonRenderer.renderLaunchedBlocks(blockEntity, partialTicks, ms, buffer, light, overlay);
        }
        if (VisualizationManager.supportsVisualization((class_1936)blockEntity.method_10997())) {
            return;
        }
        class_2338 pos = blockEntity.method_11016();
        class_2680 state = blockEntity.method_11010();
        double[] cannonAngles = SchematicannonRenderer.getCannonAngles(blockEntity, pos, partialTicks);
        double yaw = cannonAngles[0];
        double pitch = cannonAngles[1];
        double recoil = SchematicannonRenderer.getRecoil(blockEntity, partialTicks);
        ms.method_22903();
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        SuperByteBuffer connector = CachedBuffers.partial((PartialModel)AllPartialModels.SCHEMATICANNON_CONNECTOR, (class_2680)state);
        connector.translate(0.5f, 0.0f, 0.5f);
        connector.rotate((float)((yaw + 90.0) / 180.0 * Math.PI), class_2350.field_11036);
        connector.translate(-0.5f, 0.0f, -0.5f);
        connector.light(light).renderInto(ms, vb);
        SuperByteBuffer pipe = CachedBuffers.partial((PartialModel)AllPartialModels.SCHEMATICANNON_PIPE, (class_2680)state);
        pipe.translate(0.5f, 0.9375f, 0.5f);
        pipe.rotate((float)((yaw + 90.0) / 180.0 * Math.PI), class_2350.field_11036);
        pipe.rotate((float)(pitch / 180.0 * Math.PI), class_2350.field_11035);
        pipe.translate(-0.5f, -0.9375f, -0.5f);
        pipe.translate(0.0, -recoil / 100.0, 0.0);
        pipe.light(light).renderInto(ms, vb);
        ms.method_22909();
    }

    public static double[] getCannonAngles(SchematicannonBlockEntity blockEntity, class_2338 pos, float partialTicks) {
        double pitch;
        double yaw;
        class_2338 target = blockEntity.printer.getCurrentTarget();
        if (target != null) {
            class_243 diff = class_243.method_24954((class_2382)target.method_10059((class_2382)pos));
            if (blockEntity.previousTarget != null) {
                diff = class_243.method_24954((class_2382)blockEntity.previousTarget).method_1019(class_243.method_24954((class_2382)target.method_10059((class_2382)blockEntity.previousTarget)).method_1021((double)partialTicks)).method_1020(class_243.method_24954((class_2382)pos));
            }
            double diffX = diff.method_10216();
            double diffZ = diff.method_10215();
            yaw = class_3532.method_15349((double)diffX, (double)diffZ);
            yaw = yaw / Math.PI * 180.0;
            float distance = class_3532.method_15355((float)((float)(diffX * diffX + diffZ * diffZ)));
            double yOffset = 0.0f + distance * 2.0f;
            pitch = class_3532.method_15349((double)distance, (double)(diff.method_10214() * 3.0 + yOffset));
            pitch = pitch / Math.PI * 180.0 + 10.0;
        } else {
            yaw = blockEntity.defaultYaw;
            pitch = 40.0;
        }
        return new double[]{yaw, pitch};
    }

    public static double getRecoil(SchematicannonBlockEntity blockEntity, float partialTicks) {
        double recoil = 0.0;
        for (LaunchedItem launched : blockEntity.flyingBlocks) {
            if (launched.ticksRemaining == 0 || !((float)(launched.ticksRemaining + 1) - partialTicks > (float)(launched.totalTicks - 10))) continue;
            recoil = Math.max(recoil, (double)((float)(launched.ticksRemaining + 1) - partialTicks - (float)launched.totalTicks + 10.0f));
        }
        return recoil;
    }

    private static void renderLaunchedBlocks(SchematicannonBlockEntity blockEntity, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        for (LaunchedItem launched : blockEntity.flyingBlocks) {
            if (launched.ticksRemaining == 0) continue;
            class_243 start = class_243.method_24953((class_2382)blockEntity.method_11016().method_10084());
            class_243 target = class_243.method_24953((class_2382)launched.target);
            class_243 distance = target.method_1020(start);
            double yDifference = target.field_1351 - start.field_1351;
            double throwHeight = Math.sqrt(distance.method_1027()) * (double)0.6f + yDifference;
            class_243 cannonOffset = distance.method_1031(0.0, throwHeight, 0.0).method_1029().method_1021(2.0);
            start = start.method_1019(cannonOffset);
            yDifference = target.field_1351 - start.field_1351;
            float progress = ((float)launched.totalTicks - ((float)(launched.ticksRemaining + 1) - partialTicks)) / (float)launched.totalTicks;
            class_243 blockLocationXZ = target.method_1020(start).method_1021((double)progress).method_18805(1.0, 0.0, 1.0);
            float t = progress;
            double yOffset = (double)(2.0f * (1.0f - t) * t) * throwHeight + (double)(t * t) * yDifference;
            class_243 blockLocation = blockLocationXZ.method_1031(0.5, yOffset + 1.5, 0.5).method_1019(cannonOffset);
            ms.method_22903();
            ms.method_22904(blockLocation.field_1352, blockLocation.field_1351, blockLocation.field_1350);
            ms.method_46416(0.125f, 0.125f, 0.125f);
            ms.method_22907(class_7833.field_40716.rotationDegrees(360.0f * t));
            ms.method_22907(class_7833.field_40714.rotationDegrees(360.0f * t));
            ms.method_46416(-0.125f, -0.125f, -0.125f);
            if (launched instanceof LaunchedItem.ForBlockState) {
                class_2680 state = launched instanceof LaunchedItem.ForBelt ? AllBlocks.SHAFT.getDefaultState() : ((LaunchedItem.ForBlockState)launched).state;
                float scale = 0.3f;
                ms.method_22905(scale, scale, scale);
                class_776 dispatcher = class_310.method_1551().method_1541();
                switch (state.method_26217()) {
                    case field_11458: {
                        class_1087 model = dispatcher.method_3349(state);
                        model = DefaultLayerFilteringBakedModel.wrap(model);
                        model = FixedLightBakedModel.wrap((class_1087)model, (int)light);
                        dispatcher.method_3350().method_3374((class_1920)EmptyVirtualBlockGetter.FULL_DARK, model, state, class_2338.field_10980, ms, buffer.getBuffer(class_4696.method_23683((class_2680)state, (boolean)false)), false, class_5819.method_43047(), 42L, overlay);
                        break;
                    }
                    case field_11456: {
                        ((BlockRenderDispatcherAccessor)dispatcher).getBlockEntityRenderer().method_3166(new class_1799((class_1935)state.method_26204()), class_811.field_4315, ms, buffer, light, overlay);
                    }
                }
            } else if (launched instanceof LaunchedItem.ForEntity) {
                float scale = 1.2f;
                ms.method_22905(scale, scale, scale);
                class_310.method_1551().method_1480().method_23178(launched.stack, class_811.field_4318, light, overlay, ms, buffer, blockEntity.method_10997(), 0);
            }
            ms.method_22909();
            if (launched.ticksRemaining != launched.totalTicks || !blockEntity.firstRenderTick) continue;
            start = start.method_1023(0.5, 0.5, 0.5);
            blockEntity.firstRenderTick = false;
            for (int i = 0; i < 10; ++i) {
                class_5819 r = blockEntity.method_10997().method_8409();
                double sX = cannonOffset.field_1352 * (double)0.01f;
                double sY = (cannonOffset.field_1351 + 1.0) * (double)0.01f;
                double sZ = cannonOffset.field_1350 * (double)0.01f;
                double rX = (double)r.method_43057() - sX * 40.0;
                double rY = (double)r.method_43057() - sY * 40.0;
                double rZ = (double)r.method_43057() - sZ * 40.0;
                blockEntity.method_10997().method_8406((class_2394)class_2398.field_11204, start.field_1352 + rX, start.field_1351 + rY, start.field_1350 + rZ, sX, sY, sZ);
            }
        }
    }

    public boolean shouldRenderOffScreen(SchematicannonBlockEntity blockEntity) {
        return true;
    }

    public int method_33893() {
        return 128;
    }
}

