/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.link;

import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.levelWrappers.WorldHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2382;
import net.minecraft.class_2487;

public class RedstoneLinkNetworkHandler {
    static final Map<class_1936, Map<Couple<Frequency>, Set<IRedstoneLinkable>>> connections = new IdentityHashMap<class_1936, Map<Couple<Frequency>, Set<IRedstoneLinkable>>>();
    public final AtomicInteger globalPowerVersion = new AtomicInteger();

    public void onLoadWorld(class_1936 world) {
        connections.put(world, new HashMap());
        Create.LOGGER.debug("Prepared Redstone Network Space for " + String.valueOf(WorldHelper.getDimensionID((class_1936)world)));
    }

    public void onUnloadWorld(class_1936 world) {
        connections.remove(world);
        Create.LOGGER.debug("Removed Redstone Network Space for " + String.valueOf(WorldHelper.getDimensionID((class_1936)world)));
    }

    public Set<IRedstoneLinkable> getNetworkOf(class_1936 world, IRedstoneLinkable actor) {
        Couple<Frequency> key;
        Map<Couple<Frequency>, Set<IRedstoneLinkable>> networksInWorld = this.networksIn(world);
        if (!networksInWorld.containsKey(key = actor.getNetworkKey())) {
            networksInWorld.put(key, new LinkedHashSet());
        }
        return networksInWorld.get(key);
    }

    public void addToNetwork(class_1936 world, IRedstoneLinkable actor) {
        this.getNetworkOf(world, actor).add(actor);
        this.updateNetworkOf(world, actor);
    }

    public void removeFromNetwork(class_1936 world, IRedstoneLinkable actor) {
        Set<IRedstoneLinkable> network = this.getNetworkOf(world, actor);
        network.remove(actor);
        if (network.isEmpty()) {
            this.networksIn(world).remove(actor.getNetworkKey());
            return;
        }
        this.updateNetworkOf(world, actor);
    }

    public void updateNetworkOf(class_1936 world, IRedstoneLinkable actor) {
        LinkBehaviour linkBehaviour;
        Set<IRedstoneLinkable> network = this.getNetworkOf(world, actor);
        this.globalPowerVersion.incrementAndGet();
        int power = 0;
        Iterator<IRedstoneLinkable> iterator = network.iterator();
        while (iterator.hasNext()) {
            IRedstoneLinkable other = iterator.next();
            if (!other.isAlive()) {
                iterator.remove();
                continue;
            }
            if (!RedstoneLinkNetworkHandler.withinRange(actor, other) || power >= 15) continue;
            power = Math.max(other.getTransmittedStrength(), power);
        }
        if (actor instanceof LinkBehaviour && (linkBehaviour = (LinkBehaviour)actor).isListening()) {
            linkBehaviour.newPosition = true;
            linkBehaviour.setReceivedStrength(power);
        }
        for (IRedstoneLinkable other : network) {
            if (other == actor || !other.isListening() || !RedstoneLinkNetworkHandler.withinRange(actor, other)) continue;
            other.setReceivedStrength(power);
        }
    }

    public static boolean withinRange(IRedstoneLinkable from, IRedstoneLinkable to) {
        if (from == to) {
            return true;
        }
        return from.getLocation().method_19771((class_2382)to.getLocation(), (double)((Integer)AllConfigs.server().logistics.linkRange.get()).intValue());
    }

    public Map<Couple<Frequency>, Set<IRedstoneLinkable>> networksIn(class_1936 world) {
        if (!connections.containsKey(world)) {
            Create.LOGGER.warn("Tried to Access unprepared network space of " + String.valueOf(WorldHelper.getDimensionID((class_1936)world)));
            return new HashMap<Couple<Frequency>, Set<IRedstoneLinkable>>();
        }
        return connections.get(world);
    }

    public boolean hasAnyLoadedPower(Couple<Frequency> frequency) {
        for (Map<Couple<Frequency>, Set<IRedstoneLinkable>> map : connections.values()) {
            Set<IRedstoneLinkable> set = map.get(frequency);
            if (set == null || set.isEmpty()) continue;
            for (IRedstoneLinkable link : set) {
                if (link.getTransmittedStrength() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static class Frequency {
        public static final Frequency EMPTY = new Frequency(class_1799.field_8037);
        private static final Map<class_1792, Frequency> simpleFrequencies = new IdentityHashMap<class_1792, Frequency>();
        private class_1799 stack;
        private class_1792 item;
        private int color;

        public static Frequency of(class_1799 stack) {
            if (stack.method_7960()) {
                return EMPTY;
            }
            if (!stack.method_7985()) {
                return simpleFrequencies.computeIfAbsent(stack.method_7909(), $ -> new Frequency(stack));
            }
            return new Frequency(stack);
        }

        private Frequency(class_1799 stack) {
            this.stack = stack;
            this.item = stack.method_7909();
            class_2487 displayTag = stack.method_7941("display");
            this.color = displayTag != null && displayTag.method_10545("color") ? displayTag.method_10550("color") : -1;
        }

        public class_1799 getStack() {
            return this.stack;
        }

        public int hashCode() {
            return this.item.hashCode() * 31 ^ this.color;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof Frequency ? ((Frequency)obj).item == this.item && ((Frequency)obj).color == this.color : false;
        }
    }
}

