/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink.source;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayLayout;
import com.simibubi.create.content.trains.display.FlapDisplaySection;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class SingleLineDisplaySource
extends DisplaySource {
    protected abstract class_5250 provideLine(DisplayLinkContext var1, DisplayTargetStats var2);

    protected abstract boolean allowsLabeling(DisplayLinkContext var1);

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        if (isFirstLine && this.allowsLabeling(context)) {
            this.addLabelingTextBox(builder);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void addLabelingTextBox(ModularGuiLineBuilder builder) {
        builder.addTextInput(0, 137, (e, t) -> {
            e.method_1852("");
            t.withTooltip((List<class_2561>)ImmutableList.of((Object)CreateLang.translateDirect("display_source.label", new Object[0]).method_27694(s -> s.method_36139(5476833)), (Object)CreateLang.translateDirect("gui.schedule.lmb_edit", new Object[0]).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})));
        }, "Label");
    }

    @Override
    public List<class_5250> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        String label;
        class_5250 line = this.provideLine(context, stats);
        if (line == EMPTY_LINE) {
            return EMPTY;
        }
        if (this.allowsLabeling(context) && !(label = context.sourceConfig().method_10558("Label")).isEmpty()) {
            line = class_2561.method_43470((String)(label + " ")).method_10852((class_2561)line);
        }
        return ImmutableList.of((Object)line);
    }

    @Override
    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        String label;
        if (this.allowsLabeling(context) && !(label = context.sourceConfig().method_10558("Label")).isEmpty()) {
            return ImmutableList.of((Object)ImmutableList.of((Object)class_2561.method_43470((String)(label + " ")), (Object)this.provideLine(context, stats)));
        }
        return super.provideFlapDisplayText(context, stats);
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout) {
        String layoutKey = this.getFlapDisplayLayoutName(context);
        if (!this.allowsLabeling(context)) {
            if (!layout.isLayout(layoutKey)) {
                layout.configure(layoutKey, (List<FlapDisplaySection>)ImmutableList.of((Object)this.createSectionForValue(context, flapDisplay.getMaxCharCount())));
            }
            return;
        }
        String label = context.sourceConfig().method_10558("Label");
        if (label.isEmpty()) {
            if (!layout.isLayout(layoutKey)) {
                layout.configure(layoutKey, (List<FlapDisplaySection>)ImmutableList.of((Object)this.createSectionForValue(context, flapDisplay.getMaxCharCount())));
            }
            return;
        }
        String layoutName = label.length() + "_Labeled_" + layoutKey;
        if (layout.isLayout(layoutName)) {
            return;
        }
        int maxCharCount = flapDisplay.getMaxCharCount();
        FlapDisplaySection labelSection = new FlapDisplaySection((float)Math.min(maxCharCount, label.length() + 1) * 7.0f, "alphabet", false, false);
        if (label.length() + 1 < maxCharCount) {
            layout.configure(layoutName, (List<FlapDisplaySection>)ImmutableList.of((Object)labelSection, (Object)this.createSectionForValue(context, maxCharCount - label.length() - 1)));
        } else {
            layout.configure(layoutName, (List<FlapDisplaySection>)ImmutableList.of((Object)labelSection));
        }
    }

    protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
        return "Default";
    }

    protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
        return new FlapDisplaySection((float)size * 7.0f, "alphabet", false, false);
    }
}

