/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.chainConveyor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlock;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorConnectionPacket;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import me.pepperbell.simplenetworking.C2SPacket;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_746;

public class ChainConveyorConnectionHandler {
    private static class_2338 firstPos;
    private static class_5321<class_1937> firstDim;

    @Environment(value=EnvType.CLIENT)
    public static boolean onRightClick() {
        class_3965 bhr;
        class_310 mc = class_310.method_1551();
        if (!ChainConveyorConnectionHandler.isChain(mc.field_1724.method_6047())) {
            return false;
        }
        if (firstPos == null) {
            return false;
        }
        boolean missed = false;
        class_239 class_2393 = mc.field_1765;
        if (class_2393 instanceof class_3965 && (bhr = (class_3965)class_2393).method_17783() != class_239.class_240.field_1333 && !(mc.field_1687.method_8321(bhr.method_17777()) instanceof ChainConveyorBlockEntity)) {
            missed = true;
        }
        if (!mc.field_1724.method_5715() && !missed) {
            return false;
        }
        firstPos = null;
        CreateLang.translate("chain_conveyor.selection_cleared", new Object[0]).sendStatus((class_1657)mc.field_1724);
        return true;
    }

    public static class_1269 onItemUsedOnBlock(class_1657 player, class_1937 level, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        class_2338 pos = hit.method_17777();
        class_2680 blockState = level.method_8320(pos);
        if (!AllBlocks.CHAIN_CONVEYOR.has(blockState)) {
            return class_1269.field_5811;
        }
        if (!ChainConveyorConnectionHandler.isChain(itemStack)) {
            return class_1269.field_5811;
        }
        if (!player.method_7294() || player instanceof FakePlayer) {
            return class_1269.field_5811;
        }
        if (!level.method_8608()) {
            return class_1269.field_21466;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ChainConveyorBlockEntity) {
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)class_25862;
            if (ccbe.connections.size() >= (Integer)AllConfigs.server().kinetics.maxChainConveyorConnections.get()) {
                CreateLang.translate("chain_conveyor.cannot_add_more_connections", new Object[0]).style(class_124.field_1061).sendStatus(player);
                return class_1269.field_21466;
            }
        }
        if (firstPos == null || firstDim != level.method_27983()) {
            firstPos = pos;
            firstDim = level.method_27983();
            player.method_6104(hand);
            return class_1269.field_21466;
        }
        boolean success = ChainConveyorConnectionHandler.validateAndConnect((class_1936)level, pos, player, itemStack, false);
        firstPos = null;
        if (!success) {
            AllSoundEvents.DENY.play(level, player, (class_2382)pos);
            return class_1269.field_21466;
        }
        class_2498 soundtype = class_2246.field_23985.method_9564().method_26231();
        if (soundtype != null) {
            level.method_8396(player, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
        }
        return class_1269.field_21466;
    }

    private static boolean isChain(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_23983);
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientTick() {
        if (firstPos == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_2586 sourceLift = player.method_37908().method_8321(firstPos);
        if (firstDim != player.method_37908().method_27983() || !(sourceLift instanceof ChainConveyorBlockEntity)) {
            firstPos = null;
            CreateLang.translate("chain_conveyor.selection_cleared", new Object[0]).sendStatus((class_1657)player);
            return;
        }
        class_1799 stack = player.method_6047();
        class_239 hitResult = class_310.method_1551().field_1765;
        if (!ChainConveyorConnectionHandler.isChain(stack) && !ChainConveyorConnectionHandler.isChain(stack = player.method_6079())) {
            return;
        }
        if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1332) {
            ChainConveyorConnectionHandler.highlightConveyor(firstPos, 0xFFFFFF, "chain_connect");
            return;
        }
        class_1937 level = player.method_37908();
        class_3965 bhr = (class_3965)hitResult;
        class_2338 pos = bhr.method_17777();
        class_2680 hitState = level.method_8320(pos);
        if (pos.equals((Object)firstPos)) {
            ChainConveyorConnectionHandler.highlightConveyor(firstPos, 0xFFFFFF, "chain_connect");
            CreateLang.translate("chain_conveyor.select_second", new Object[0]).sendStatus((class_1657)player);
            return;
        }
        if (!(hitState.method_26204() instanceof ChainConveyorBlock)) {
            ChainConveyorConnectionHandler.highlightConveyor(firstPos, 0xFFFFFF, "chain_connect");
            return;
        }
        boolean success = ChainConveyorConnectionHandler.validateAndConnect((class_1936)level, pos, (class_1657)player, stack, true);
        if (success) {
            CreateLang.translate("chain_conveyor.valid_connection", new Object[0]).style(class_124.field_1060).sendStatus((class_1657)player);
        }
        int color = success ? 9817409 : 15359019;
        ChainConveyorConnectionHandler.highlightConveyor(firstPos, color, "chain_connect");
        ChainConveyorConnectionHandler.highlightConveyor(pos, color, "chain_connect_to");
        class_243 from = class_243.method_24953((class_2382)pos);
        class_243 to = class_243.method_24953((class_2382)firstPos);
        class_243 diff = from.method_1020(to);
        if (diff.method_1033() < 1.0) {
            return;
        }
        from = from.method_1020(diff.method_1029().method_1021(0.5));
        to = to.method_1019(diff.method_1029().method_1021(0.5));
        class_243 normal = diff.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029().method_1021(0.875);
        Outliner.getInstance().showLine((Object)"chain_connect_line", from.method_1019(normal), to.method_1019(normal)).lineWidth(0.0625f).colored(color);
        Outliner.getInstance().showLine((Object)"chain_connect_line_1", from.method_1020(normal), to.method_1020(normal)).lineWidth(0.0625f).colored(color);
    }

    private static void highlightConveyor(class_2338 pos, int color, String key) {
        for (int y : Iterate.zeroAndOne) {
            class_243 prevV = VecHelper.rotate((class_243)new class_243(0.0, 0.125 + (double)y * 0.75, 1.25), (double)-22.5, (class_2350.class_2351)class_2350.class_2351.field_11052).method_1019(class_243.method_24955((class_2382)pos));
            for (int i = 0; i < 8; ++i) {
                class_243 v = VecHelper.rotate((class_243)new class_243(0.0, 0.125 + (double)y * 0.75, 1.25), (double)(22.5 + (double)(i * 45)), (class_2350.class_2351)class_2350.class_2351.field_11052).method_1019(class_243.method_24955((class_2382)pos));
                Outliner.getInstance().showLine((Object)(key + y + i), prevV, v).lineWidth(0.0625f).colored(color);
                prevV = v;
            }
        }
    }

    public static boolean validateAndConnect(class_1936 level, class_2338 pos, class_1657 player, class_1799 chain, boolean simulate) {
        if (!simulate && player.method_5715()) {
            CreateLang.translate("chain_conveyor.selection_cleared", new Object[0]).sendStatus(player);
            return false;
        }
        if (pos.equals((Object)firstPos)) {
            return false;
        }
        if (!pos.method_19771((class_2382)firstPos, (double)((Integer)AllConfigs.server().kinetics.maxChainConveyorLength.get()).intValue())) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.too_far");
        }
        if (pos.method_19771((class_2382)firstPos, 2.5)) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.too_close");
        }
        class_243 diff = class_243.method_24954((class_2382)pos.method_10059((class_2382)firstPos));
        double horizontalDistance = diff.method_18805(1.0, 0.0, 1.0).method_1033() - 1.5;
        if (horizontalDistance <= 0.0) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.cannot_connect_vertically");
        }
        if (Math.abs(diff.field_1351) / horizontalDistance > 1.0) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.too_steep");
        }
        ChainConveyorBlock chainConveyorBlock = (ChainConveyorBlock)AllBlocks.CHAIN_CONVEYOR.get();
        ChainConveyorBlockEntity sourceLift = (ChainConveyorBlockEntity)chainConveyorBlock.getBlockEntity((class_1922)level, firstPos);
        ChainConveyorBlockEntity targetLift = (ChainConveyorBlockEntity)chainConveyorBlock.getBlockEntity((class_1922)level, pos);
        if (targetLift.connections.size() >= (Integer)AllConfigs.server().kinetics.maxChainConveyorConnections.get()) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.cannot_add_more_connections");
        }
        if (targetLift.connections.contains(firstPos.method_10059((class_2382)pos))) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.already_connected");
        }
        if (sourceLift == null || targetLift == null) {
            return ChainConveyorConnectionHandler.fail("chain_conveyor.blocks_invalid");
        }
        if (!player.method_7337()) {
            int chainCost = ChainConveyorBlockEntity.getChainCost(pos.method_10059((class_2382)firstPos));
            boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory(player, chain, chainCost, true);
            if (simulate) {
                BlueprintOverlayRenderer.displayChainRequirements(chain.method_7909(), chainCost, hasEnough);
            }
            if (!hasEnough) {
                return ChainConveyorConnectionHandler.fail("chain_conveyor.not_enough_chains");
            }
        }
        if (simulate) {
            return true;
        }
        AllPackets.getChannel().sendToServer((C2SPacket)new ChainConveyorConnectionPacket(firstPos, pos, chain, true));
        CreateLang.text("").sendStatus(player);
        firstPos = null;
        firstDim = null;
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private static boolean fail(String message) {
        CreateLang.translate(message, new Object[0]).style(class_124.field_1061).sendStatus((class_1657)class_310.method_1551().field_1724);
        return false;
    }
}

