/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper.terrainzapper;

import com.simibubi.create.content.equipment.zapper.ZapperItem;
import com.simibubi.create.content.equipment.zapper.terrainzapper.FlattenTool;
import com.simibubi.create.foundation.gui.AllIcons;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.Lang;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public enum TerrainTools {
    Fill(AllIcons.I_FILL),
    Place(AllIcons.I_PLACE),
    Replace(AllIcons.I_REPLACE),
    Clear(AllIcons.I_CLEAR),
    Overlay(AllIcons.I_OVERLAY),
    Flatten(AllIcons.I_FLATTEN);

    public String translationKey = Lang.asId((String)this.name());
    public AllIcons icon;

    private TerrainTools(AllIcons icon) {
        this.icon = icon;
    }

    public boolean requiresSelectedBlock() {
        return this != Clear && this != Flatten;
    }

    public void run(class_1937 world, List<class_2338> targetPositions, class_2350 facing, @Nullable class_2680 paintedState, @Nullable class_2487 data, class_1657 player) {
        switch (this) {
            case Clear: {
                targetPositions.forEach(p -> world.method_8501(p, class_2246.field_10124.method_9564()));
                break;
            }
            case Fill: {
                targetPositions.forEach(p -> {
                    class_2680 toReplace = world.method_8320(p);
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.method_8501(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            }
            case Flatten: {
                FlattenTool.apply(world, targetPositions, facing);
                break;
            }
            case Overlay: {
                targetPositions.forEach(p -> {
                    class_2680 toOverlay = world.method_8320(p);
                    if (TerrainTools.isReplaceable(toOverlay)) {
                        return;
                    }
                    if (toOverlay == paintedState) {
                        return;
                    }
                    class_2680 toReplace = world.method_8320(p = p.method_10084());
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.method_8501(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            }
            case Place: {
                targetPositions.forEach(p -> {
                    world.method_8501(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            }
            case Replace: {
                targetPositions.forEach(p -> {
                    class_2680 toReplace = world.method_8320(p);
                    if (TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.method_8501(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
            }
        }
    }

    public static boolean isReplaceable(class_2680 toReplace) {
        return toReplace.method_45474();
    }
}

