/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ClientContraption;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedBlockAndTintGetter;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.material.CardinalLightingMode;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.SectionTrackedVisual;
import dev.engine_room.flywheel.api.visual.ShaderLightVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visual.Visual;
import dev.engine_room.flywheel.api.visualization.BlockEntityVisualizer;
import dev.engine_room.flywheel.api.visualization.VisualEmbedding;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizerRegistry;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.ModelUtil;
import dev.engine_room.flywheel.lib.model.SimpleModel;
import dev.engine_room.flywheel.lib.model.baked.FabricBlockModelBuilder;
import dev.engine_room.flywheel.lib.task.ForEachPlan;
import dev.engine_room.flywheel.lib.task.NestedPlan;
import dev.engine_room.flywheel.lib.task.PlanMap;
import dev.engine_room.flywheel.lib.task.RunnablePlan;
import dev.engine_room.flywheel.lib.visual.AbstractEntityVisual;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.MutablePair;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ContraptionVisual<E extends AbstractContraptionEntity>
extends AbstractEntityVisual<E>
implements DynamicVisual,
TickableVisual,
ShaderLightVisual {
    protected static final int DEFAULT_LIGHT_PADDING = 1;
    protected final VisualEmbedding embedding;
    protected final List<BlockEntityVisual<?>> children = new ArrayList();
    protected final List<ActorVisual> actors = new ArrayList<ActorVisual>();
    protected final PlanMap<DynamicVisual, DynamicVisual.Context> dynamicVisuals = new PlanMap();
    protected final PlanMap<TickableVisual, TickableVisual.Context> tickableVisuals = new PlanMap();
    protected TransformedInstance structure;
    protected SectionTrackedVisual.SectionCollector sectionCollector;
    protected long minSection;
    protected long maxSection;
    protected int lightPaddingBlocks = 1;
    protected int lastStructureVersion;
    protected int lastVersionChildren;
    private final class_4587 contraptionMatrix = new class_4587();

    public ContraptionVisual(VisualizationContext ctx, E entity, float partialTick) {
        super(ctx, entity, partialTick);
        this.embedding = ctx.createEmbedding(class_2382.field_11176);
        this.setEmbeddingMatrices(partialTick);
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        if (contraption == null) {
            return;
        }
        ClientContraption clientContraption = contraption.getOrCreateClientContraptionLazy();
        this.setupStructure(clientContraption);
        this.setupChildren(contraption, clientContraption, partialTick);
    }

    private void setupStructure(ClientContraption clientContraption) {
        VirtualRenderWorld renderLevel = clientContraption.getRenderLevel();
        final ClientContraption.RenderedBlocks blocks = clientContraption.getRenderedBlocks();
        WrappedBlockAndTintGetter modelWorld = new WrappedBlockAndTintGetter((class_1920)renderLevel){

            @Override
            public class_2680 method_8320(class_2338 pos) {
                return blocks.lookup().apply(pos);
            }
        };
        SimpleModel model = new FabricBlockModelBuilder((class_1920)modelWorld, blocks.positions()).materialFunc((renderType, shaded) -> {
            Material material = ModelUtil.getMaterial((class_1921)renderType, (boolean)shaded);
            if (material != null && material.cardinalLightingMode() == CardinalLightingMode.ENTITY) {
                return SimpleMaterial.builderOf((Material)material).cardinalLightingMode(CardinalLightingMode.CHUNK).build();
            }
            return material;
        }).build();
        Instancer instancer = this.embedding.instancerProvider().instancer(InstanceTypes.TRANSFORMED, (Model)model);
        if (this.structure == null) {
            this.structure = (TransformedInstance)instancer.createInstance();
        } else {
            instancer.stealInstance((Instance)this.structure);
        }
        this.structure.setChanged();
        this.lastStructureVersion = clientContraption.structureVersion();
    }

    private void setupChildren(Contraption contraption, ClientContraption clientContraption, float partialTick) {
        this.children.forEach(Visual::delete);
        this.children.clear();
        this.dynamicVisuals.clear();
        this.tickableVisuals.clear();
        for (class_2586 be : clientContraption.renderedBlockEntityView) {
            this.setupVisualizer(be, partialTick);
        }
        VirtualRenderWorld renderLevel = clientContraption.getRenderLevel();
        this.actors.forEach(ActorVisual::delete);
        this.actors.clear();
        for (MutablePair<class_3499.class_3501, MovementContext> actor : contraption.getActors()) {
            this.setupActor(actor, renderLevel);
        }
        this.lastVersionChildren = clientContraption.childrenVersion();
    }

    protected <T extends class_2586> void setupVisualizer(T be, float partialTicks) {
        BlockEntityVisualizer visualizer = VisualizerRegistry.getVisualizer((class_2591)be.method_11017());
        if (visualizer == null) {
            return;
        }
        BlockEntityVisual visual = visualizer.createVisual((VisualizationContext)this.embedding, be, partialTicks);
        this.children.add(visual);
        if (visual instanceof DynamicVisual) {
            DynamicVisual dynamic = (DynamicVisual)visual;
            this.dynamicVisuals.add((Object)dynamic, dynamic.planFrame());
        }
        if (visual instanceof TickableVisual) {
            TickableVisual tickable = (TickableVisual)visual;
            this.tickableVisuals.add((Object)tickable, tickable.planTick());
        }
    }

    protected void setupActor(MutablePair<class_3499.class_3501, MovementContext> actor, VirtualRenderWorld renderLevel) {
        class_3499.class_3501 blockInfo;
        MovementBehaviour movementBehaviour;
        MovementContext context = (MovementContext)actor.getRight();
        if (context == null) {
            return;
        }
        if (context.world == null) {
            context.world = this.level;
        }
        if ((movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)(blockInfo = (class_3499.class_3501)actor.getLeft()).comp_1342())) == null) {
            return;
        }
        ActorVisual visual = movementBehaviour.createVisual((VisualizationContext)this.embedding, renderLevel, context);
        if (visual == null) {
            return;
        }
        this.actors.add(visual);
    }

    public Plan<TickableVisual.Context> planTick() {
        return NestedPlan.of((Plan[])new Plan[]{ForEachPlan.of(() -> this.actors, ActorVisual::tick), this.tickableVisuals});
    }

    public Plan<DynamicVisual.Context> planFrame() {
        return RunnablePlan.of(this::beginFrame).then((Plan)NestedPlan.of((Plan[])new Plan[]{ForEachPlan.of(() -> this.actors, ActorVisual::beginFrame), this.dynamicVisuals}));
    }

    protected void beginFrame(DynamicVisual.Context context) {
        float partialTick = context.partialTick();
        this.setEmbeddingMatrices(partialTick);
        this.checkAndUpdateLightSections();
        Contraption contraption = ((AbstractContraptionEntity)this.entity).getContraption();
        ClientContraption clientContraption = contraption.getOrCreateClientContraptionLazy();
        if (this.lastStructureVersion != clientContraption.structureVersion()) {
            this.setupStructure(clientContraption);
        }
        if (this.lastVersionChildren != clientContraption.childrenVersion()) {
            this.setupChildren(contraption, clientContraption, partialTick);
        }
    }

    private void setEmbeddingMatrices(float partialTick) {
        double z;
        double y;
        double x;
        class_2382 origin = this.renderOrigin();
        if (((AbstractContraptionEntity)this.entity).isPrevPosInvalid()) {
            x = ((AbstractContraptionEntity)this.entity).method_23317() - (double)origin.method_10263();
            y = ((AbstractContraptionEntity)this.entity).method_23318() - (double)origin.method_10264();
            z = ((AbstractContraptionEntity)this.entity).method_23321() - (double)origin.method_10260();
        } else {
            x = class_3532.method_16436((double)partialTick, (double)((AbstractContraptionEntity)this.entity).field_6014, (double)((AbstractContraptionEntity)this.entity).method_23317()) - (double)origin.method_10263();
            y = class_3532.method_16436((double)partialTick, (double)((AbstractContraptionEntity)this.entity).field_6036, (double)((AbstractContraptionEntity)this.entity).method_23318()) - (double)origin.method_10264();
            z = class_3532.method_16436((double)partialTick, (double)((AbstractContraptionEntity)this.entity).field_5969, (double)((AbstractContraptionEntity)this.entity).method_23321()) - (double)origin.method_10260();
        }
        this.contraptionMatrix.method_34426();
        this.contraptionMatrix.method_22904(x, y, z);
        ((AbstractContraptionEntity)this.entity).applyLocalTransforms(this.contraptionMatrix, partialTick);
        this.embedding.transforms((Matrix4fc)this.contraptionMatrix.method_23760().method_23761(), (Matrix3fc)this.contraptionMatrix.method_23760().method_23762());
    }

    public void setSectionCollector(SectionTrackedVisual.SectionCollector collector) {
        this.sectionCollector = collector;
        this.checkAndUpdateLightSections();
    }

    private void checkAndUpdateLightSections() {
        class_238 boundingBox = ((AbstractContraptionEntity)this.entity).method_5829();
        int minSectionX = class_4076.method_18675((int)(class_3532.method_15357((double)boundingBox.field_1323) - this.lightPaddingBlocks));
        int minSectionY = class_4076.method_18675((int)(class_3532.method_15357((double)boundingBox.field_1322) - this.lightPaddingBlocks));
        int minSectionZ = class_4076.method_18675((int)(class_3532.method_15357((double)boundingBox.field_1321) - this.lightPaddingBlocks));
        int maxSectionX = class_4076.method_18675((int)(class_3532.method_15384((double)boundingBox.field_1320) + this.lightPaddingBlocks));
        int maxSectionY = class_4076.method_18675((int)(class_3532.method_15384((double)boundingBox.field_1325) + this.lightPaddingBlocks));
        int maxSectionZ = class_4076.method_18675((int)(class_3532.method_15384((double)boundingBox.field_1324) + this.lightPaddingBlocks));
        if (this.minSection == class_4076.method_18685((int)minSectionX, (int)minSectionY, (int)minSectionZ) && this.maxSection == class_4076.method_18685((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ)) {
            return;
        }
        this.minSection = class_4076.method_18685((int)minSectionX, (int)minSectionY, (int)minSectionZ);
        this.maxSection = class_4076.method_18685((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ);
        LongArraySet longSet = new LongArraySet();
        for (int x = minSectionX; x <= maxSectionX; ++x) {
            for (int y = minSectionY; y <= maxSectionY; ++y) {
                for (int z = minSectionZ; z <= maxSectionZ; ++z) {
                    longSet.add(class_4076.method_18685((int)x, (int)y, (int)z));
                }
            }
        }
        this.sectionCollector.sections((LongSet)longSet);
    }

    protected void _delete() {
        this.children.forEach(Visual::delete);
        this.actors.forEach(ActorVisual::delete);
        if (this.structure != null) {
            this.structure.delete();
        }
        this.embedding.delete();
    }
}

