/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.mounted;

import com.simibubi.create.AllItems;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.contraption.ContraptionMovementSetting;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.data.ContraptionPickupLimiting;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.AdventureUtil;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.util.MinecartAndRailUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import org.apache.commons.lang3.tuple.MutablePair;

public class MinecartContraptionItem
extends class_1792 {
    private final class_1688.class_1689 minecartType;
    private static final class_2357 DISPENSER_BEHAVIOR = new class_2347(){
        private final class_2347 behaviourDefaultDispenseItem = new class_2347();

        public class_1799 method_10135(class_2342 source, class_1799 stack) {
            double d3;
            class_2768 railshape;
            if (!MinecartContraptionItem.canPlace()) {
                return this.behaviourDefaultDispenseItem.dispense(source, stack);
            }
            class_2350 direction = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_3218 world = source.method_10207();
            double d0 = source.method_10216() + (double)direction.method_10148() * 1.125;
            double d1 = Math.floor(source.method_10214()) + (double)direction.method_10164();
            double d2 = source.method_10215() + (double)direction.method_10165() * 1.125;
            class_2338 blockpos = source.method_10122().method_10093(direction);
            class_2680 blockstate = world.method_8320(blockpos);
            class_2768 class_27682 = railshape = blockstate.method_26204() instanceof class_2241 ? MinecartAndRailUtil.getDirectionOfRail((class_2680)blockstate, (class_1922)world, (class_2338)blockpos, null) : class_2768.field_12665;
            if (blockstate.method_26164(class_3481.field_15463)) {
                d3 = railshape.method_11897() ? 0.6 : 0.1;
            } else {
                if (!blockstate.method_26215() || !world.method_8320(blockpos.method_10074()).method_26164(class_3481.field_15463)) {
                    return this.behaviourDefaultDispenseItem.dispense(source, stack);
                }
                class_2680 blockstate1 = world.method_8320(blockpos.method_10074());
                class_2768 railshape1 = blockstate1.method_26204() instanceof class_2241 ? MinecartAndRailUtil.getDirectionOfRail((class_2680)blockstate1, (class_1922)world, (class_2338)blockpos.method_10074(), null) : class_2768.field_12665;
                d3 = direction != class_2350.field_11033 && railshape1.method_11897() ? -0.4 : -0.9;
            }
            class_1688 abstractminecartentity = class_1688.method_7523((class_1937)world, (double)d0, (double)(d1 + d3), (double)d2, (class_1688.class_1689)((MinecartContraptionItem)stack.method_7909()).minecartType);
            if (stack.method_7938()) {
                abstractminecartentity.method_5665(stack.method_7964());
            }
            world.method_8649((class_1297)abstractminecartentity);
            MinecartContraptionItem.addContraptionToMinecart((class_1937)world, stack, abstractminecartentity, direction);
            stack.method_7934(1);
            return stack;
        }

        protected void method_10136(class_2342 source) {
            source.method_10207().method_20290(1000, source.method_10122(), 0);
        }
    };

    public static MinecartContraptionItem rideable(class_1792.class_1793 builder) {
        return new MinecartContraptionItem(class_1688.class_1689.field_7674, builder);
    }

    public static MinecartContraptionItem furnace(class_1792.class_1793 builder) {
        return new MinecartContraptionItem(class_1688.class_1689.field_7679, builder);
    }

    public static MinecartContraptionItem chest(class_1792.class_1793 builder) {
        return new MinecartContraptionItem(class_1688.class_1689.field_7678, builder);
    }

    public boolean method_31568() {
        return (Boolean)AllConfigs.server().kinetics.minecartContraptionInContainers.get();
    }

    private MinecartContraptionItem(class_1688.class_1689 minecartTypeIn, class_1792.class_1793 builder) {
        super(builder);
        this.minecartType = minecartTypeIn;
        class_2315.method_10009((class_1935)this, (class_2357)DISPENSER_BEHAVIOR);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 blockpos;
        class_1937 world = context.method_8045();
        class_2680 blockstate = world.method_8320(blockpos = context.method_8037());
        if (!blockstate.method_26164(class_3481.field_15463)) {
            return class_1269.field_5814;
        }
        if (!MinecartContraptionItem.canPlace()) {
            class_1657 player = context.method_8036();
            if (player != null) {
                class_5250 message = CreateLang.translateDirect("contraption.minecart_contraption_illegal_placement", new Object[0]).method_27692(class_124.field_1061);
                player.method_7353((class_2561)message, true);
            }
            return class_1269.field_5814;
        }
        class_1799 itemstack = context.method_8041();
        if (!world.field_9236) {
            class_2768 railshape = blockstate.method_26204() instanceof class_2241 ? MinecartAndRailUtil.getDirectionOfRail((class_2680)blockstate, (class_1922)world, (class_2338)blockpos, null) : class_2768.field_12665;
            double d0 = 0.0;
            if (railshape.method_11897()) {
                d0 = 0.5;
            }
            class_1688 abstractminecartentity = class_1688.method_7523((class_1937)world, (double)((double)blockpos.method_10263() + 0.5), (double)((double)blockpos.method_10264() + 0.0625 + d0), (double)((double)blockpos.method_10260() + 0.5), (class_1688.class_1689)this.minecartType);
            if (itemstack.method_7938()) {
                abstractminecartentity.method_5665(itemstack.method_7964());
            }
            class_1657 player = context.method_8036();
            world.method_8649((class_1297)abstractminecartentity);
            MinecartContraptionItem.addContraptionToMinecart(world, itemstack, abstractminecartentity, player == null ? null : player.method_5735());
        }
        itemstack.method_7934(1);
        return class_1269.field_5812;
    }

    private static boolean canPlace() {
        return (Boolean)AllConfigs.server().kinetics.contraptionPlacing.get();
    }

    public static void addContraptionToMinecart(class_1937 world, class_1799 itemstack, class_1688 cart, @Nullable class_2350 newFacing) {
        class_2487 tag = itemstack.method_7948();
        if (tag.method_10545("Contraption")) {
            class_2487 contraptionTag = tag.method_10562("Contraption");
            class_2350 intialOrientation = (class_2350)NBTHelper.readEnum((class_2487)contraptionTag, (String)"InitialOrientation", class_2350.class);
            Contraption mountedContraption = Contraption.fromNBT(world, contraptionTag, false);
            OrientedContraptionEntity contraptionEntity = newFacing == null ? OrientedContraptionEntity.create(world, mountedContraption, intialOrientation) : OrientedContraptionEntity.createAtYaw(world, mountedContraption, intialOrientation, newFacing.method_10144());
            contraptionEntity.method_5804((class_1297)cart);
            contraptionEntity.method_5814(cart.method_23317(), cart.method_23318(), cart.method_23321());
            world.method_8649((class_1297)contraptionEntity);
        }
    }

    public String method_7866(class_1799 stack) {
        return "item.create.minecart_contraption";
    }

    public static class_1269 wrenchCanBeUsedToPickUpMinecartContraptions(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        Object e;
        class_1688.class_1689 type;
        if (player == null || entity == null) {
            return class_1269.field_5811;
        }
        if (!((Boolean)AllConfigs.server().kinetics.survivalContraptionPickup.get()).booleanValue() && !player.method_7337()) {
            return class_1269.field_5811;
        }
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        if (AdventureUtil.isAdventure(player)) {
            return class_1269.field_5811;
        }
        class_1799 wrench = player.method_5998(hand);
        if (!AllItems.WRENCH.isIn(wrench)) {
            return class_1269.field_5811;
        }
        if (entity instanceof AbstractContraptionEntity) {
            entity = entity.method_5854();
        }
        if (!(entity instanceof class_1688)) {
            return class_1269.field_5811;
        }
        class_1688 cart = (class_1688)entity;
        if (!entity.method_5805()) {
            return class_1269.field_5811;
        }
        if (player instanceof DeployerFakePlayer) {
            DeployerFakePlayer dfp = (DeployerFakePlayer)player;
            if (dfp.onMinecartContraption) {
                return class_1269.field_5811;
            }
        }
        if ((type = cart.method_7518()) != class_1688.class_1689.field_7674 && type != class_1688.class_1689.field_7679 && type != class_1688.class_1689.field_7678) {
            return class_1269.field_5811;
        }
        List passengers = cart.method_5685();
        if (passengers.isEmpty() || !((e = passengers.get(0)) instanceof OrientedContraptionEntity)) {
            return class_1269.field_5811;
        }
        OrientedContraptionEntity oce = (OrientedContraptionEntity)((Object)e);
        Contraption contraption = oce.getContraption();
        if (ContraptionMovementSetting.isNoPickup(contraption.getBlocks().values())) {
            player.method_7353((class_2561)CreateLang.translateDirect("contraption.minecart_contraption_illegal_pickup", new Object[0]).method_27692(class_124.field_1061), true);
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        contraption.stop(world);
        for (MutablePair<class_3499.class_3501, MovementContext> pair : contraption.getActors()) {
            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)((class_3499.class_3501)pair.left).comp_1342());
            if (!(movementBehaviour instanceof PortableStorageInterfaceMovement)) continue;
            PortableStorageInterfaceMovement psim = (PortableStorageInterfaceMovement)movementBehaviour;
            psim.reset((MovementContext)pair.right);
        }
        class_1799 generatedStack = MinecartContraptionItem.create(type, oce).method_7977(entity.method_5797());
        if (ContraptionPickupLimiting.isTooLargeForPickup(generatedStack.method_7953(new class_2487()))) {
            class_5250 message = CreateLang.translateDirect("contraption.minecart_contraption_too_big", new Object[0]).method_27692(class_124.field_1061);
            player.method_7353((class_2561)message, true);
            return class_1269.field_5811;
        }
        if (contraption.getBlocks().size() > 200) {
            AllAdvancements.CART_PICKUP.awardTo(player);
        }
        player.method_31548().method_7398(generatedStack);
        oce.method_31472();
        entity.method_31472();
        return class_1269.field_5812;
    }

    public static class_1799 create(class_1688.class_1689 type, OrientedContraptionEntity entity) {
        class_1799 stack = class_1799.field_8037;
        switch (type) {
            case field_7674: {
                stack = AllItems.MINECART_CONTRAPTION.asStack();
                break;
            }
            case field_7679: {
                stack = AllItems.FURNACE_MINECART_CONTRAPTION.asStack();
                break;
            }
            case field_7678: {
                stack = AllItems.CHEST_MINECART_CONTRAPTION.asStack();
                break;
            }
        }
        if (stack.method_7960()) {
            return stack;
        }
        class_2487 tag = entity.getContraption().writeNBT(false);
        tag.method_10551("UUID");
        tag.method_10551("Pos");
        tag.method_10551("Motion");
        NBTHelper.writeEnum((class_2487)tag, (String)"InitialOrientation", (Enum)entity.getInitialOrientation());
        stack.method_7948().method_10566("Contraption", (class_2520)tag);
        return stack;
    }
}

