/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1091;
import net.minecraft.class_1163;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1920;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3756;
import net.minecraft.class_4002;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5614;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_6395;
import net.minecraft.class_6677;
import net.minecraft.class_707;
import net.minecraft.class_7752;
import net.minecraft.class_7761;
import net.minecraft.class_837;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.client.particle.BWGParticles;
import net.potionstudios.biomeswevegone.client.particle.particles.FallingLeafParticle;
import net.potionstudios.biomeswevegone.client.particle.particles.FireFlyParticle;
import net.potionstudios.biomeswevegone.client.renderer.entity.boat.BWGBoatRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.manowar.ManOWarRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.oddion.OddionRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.pumpkinwarden.PumpkinWardenRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.wreath.WreathRenderer;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.decoration.Wreath;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.entities.BWGBlockEntityType;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;
import org.apache.logging.log4j.util.TriConsumer;

public class BiomesWeveGoneClient {
    private static final class_3756 NOISE = new class_3756((class_5819)new class_6677(1L));

    public static void onInitialize() {
        BWGWoodSet.woodsets().forEach(set -> BiomesWeveGoneClient.registerWoodTypes(set.woodType()));
    }

    private static void registerWoodTypes(class_4719 woodType) {
        class_4722.field_21712.put(woodType, class_4722.method_24064((class_4719)woodType));
        class_4722.field_40515.put(woodType, class_4722.method_45782((class_4719)woodType));
    }

    public static void registerEntityRenderers(BiConsumer<class_1299<? extends class_1297>, class_5617> consumer) {
        consumer.accept(BWGEntityType.MAN_O_WAR.get(), ManOWarRenderer::new);
        consumer.accept(BWGEntityType.PUMPKIN_WARDEN.get(), PumpkinWardenRenderer::new);
        consumer.accept(BWGEntityType.ODDION.get(), OddionRenderer::new);
        consumer.accept(BWGEntityType.BWG_BOAT.get(), context -> new BWGBoatRenderer(context, false));
        consumer.accept(BWGEntityType.BWG_CHEST_BOAT.get(), context -> new BWGBoatRenderer(context, true));
        consumer.accept(BWGEntityType.WREATH.get(), WreathRenderer::new);
    }

    public static void registerBlockEntityRenderers(BiConsumer<class_2591<? extends class_2586>, class_5614> consumer) {
        consumer.accept(BWGBlockEntityType.SIGNS.get(), class_837::new);
        consumer.accept(BWGBlockEntityType.HANGING_SIGNS.get(), class_7761::new);
    }

    public static void registerLayerDefinitions(BiConsumer<class_5601, Supplier<class_5607>> consumer) {
        for (BWGBoatEntity.Type type : BWGBoatEntity.Type.values()) {
            consumer.accept(BWGBoatRenderer.createBoatModelName(type), class_554::method_31985);
            consumer.accept(BWGBoatRenderer.createChestBoatModelName(type), class_7752::method_45708);
        }
    }

    public static void registerAdditionalModels(Consumer<class_1091> consumer) {
        Arrays.stream(Wreath.Type.values()).forEach(type -> consumer.accept(new class_1091("biomeswevegone", type.method_15434() + "_wreath", "")));
    }

    public static void registerParticles(BiConsumer<class_2400, Function<class_4002, class_707<class_2400>>> consumer) {
        consumer.accept(BWGParticles.FIREFLY.get(), FireFlyParticle.Provider::new);
        consumer.accept(BWGParticles.BOREALIS_GLINT.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.WITCH_HAZEL_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.WHITE_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.YELLOW_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.RED_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.SILVER_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.IRONWOOD_LEAVES.get(), FallingLeafParticle.Provider::new);
    }

    public static void registerItemProperties(TriConsumer<class_1792, class_2960, class_6395> consumer) {
        consumer.accept((Object)BWGBlocks.PUMPKIN_BURROW.get().method_8389(), (Object)BiomesWeveGone.id("occupied"), (itemStack, clientLevel, livingEntity, i) -> {
            if (livingEntity != null && itemStack.method_31574(BWGBlocks.PUMPKIN_BURROW.get().method_8389()) && itemStack.method_7969() != null) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    public static void registerBlockColors(BiConsumer<class_322, class_2248[]> consumer) {
        consumer.accept((state, view, pos, tintIndex) -> view != null && pos != null ? class_1163.method_4962((class_1920)view, (class_2338)pos) : class_1933.method_49724(), new class_2248[]{(class_2248)BWGBlocks.FLOWER_PATCH.get(), (class_2248)BWGBlocks.TINY_LILY_PADS.get(), (class_2248)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), (class_2248)BWGBlocks.OVERGROWN_DACITE.get(), (class_2248)BWGBlocks.WHITE_OVERGROWN_DACITE.get(), (class_2248)BWGBlocks.OVERGROWN_STONE.get(), (class_2248)BWGBlocks.LUSH_GRASS_BLOCK.get(), (class_2248)BWGBlocks.WHITE_SAKURA_PETALS.get(), (class_2248)BWGBlocks.YELLOW_SAKURA_PETALS.get()});
        consumer.accept((state, view, pos, tintIndex) -> view != null && pos != null ? class_1163.method_4966((class_1920)view, (class_2338)pos) : class_1926.method_8344((double)0.5, (double)1.0), new class_2248[]{(class_2248)BWGBlocks.CLOVER_PATCH.get(), (class_2248)BWGBlocks.LEAF_PILE.get(), (class_2248)BWGBlocks.POISON_IVY.get(), BWGWood.MAHOGANY.leaves(), BWGWood.WILLOW.leaves(), BWGWood.MAPLE.leaves(), (class_2248)BWGWood.YUCCA_LEAVES.get(), (class_2248)BWGWood.FLOWERING_YUCCA_LEAVES.get(), (class_2248)BWGWood.RIPE_YUCCA_LEAVES.get(), BWGWood.CYPRESS.leaves()});
        consumer.accept((state, view, pos, tintIndex) -> BiomesWeveGoneClient.getBorealisIceColor(Objects.requireNonNullElse(pos, class_2338.field_10980)), new class_2248[]{(class_2248)BWGBlocks.BOREALIS_ICE.get(), (class_2248)BWGBlocks.PACKED_BOREALIS_ICE.get()});
        consumer.accept((state, view, pos, tintIndex) -> view != null && pos != null ? class_1163.method_4961((class_1920)view, (class_2338)pos) : -1, new class_2248[]{BWGBlocks.CARVED_BARREL_CACTUS.get()});
    }

    public static void registerBlockItemColors(Consumer<class_2248[]> consumer) {
        consumer.accept(new class_2248[]{(class_2248)BWGBlocks.TINY_LILY_PADS.get(), (class_2248)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), (class_2248)BWGBlocks.CLOVER_PATCH.get(), (class_2248)BWGBlocks.LEAF_PILE.get(), (class_2248)BWGBlocks.POISON_IVY.get(), BWGWood.MAHOGANY.leaves(), BWGWood.WILLOW.leaves(), BWGWood.MAPLE.leaves(), (class_2248)BWGWood.YUCCA_LEAVES.get(), (class_2248)BWGWood.FLOWERING_YUCCA_LEAVES.get(), (class_2248)BWGWood.RIPE_YUCCA_LEAVES.get(), BWGWood.CYPRESS.leaves(), (class_2248)BWGBlocks.LUSH_GRASS_BLOCK.get(), (class_2248)BWGBlocks.OVERGROWN_DACITE.get(), (class_2248)BWGBlocks.OVERGROWN_STONE.get()});
    }

    private static int getBorealisIceColor(class_2338 pos) {
        float factor = (float)((NOISE.method_33658((double)((float)pos.method_10263() * 0.01f), (double)((float)pos.method_10264() * 0.01f), (double)((float)pos.method_10260() * 0.01f)) + 1.0) * 0.5);
        float hue = 320.0f - 200.0f * factor;
        return BiomesWeveGoneClient.HSBtoRGB(hue / 360.0f, 0.6f, 1.0f);
    }

    private static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }
}

