/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.blocks.basis.FurBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.joml.Vector3f;

public class LucerniaFeature
extends DefaultFeature {
    private static final class_2350[] DIRECTIONS = class_2350.values();
    private static final Function<class_2680, Boolean> REPLACE = state -> {
        if (state.method_26204() == EndBlocks.LUCERNIA_LEAVES) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((class_2680)state);
    };
    private static final Function<class_2680, Boolean> IGNORE = EndBlocks.LUCERNIA::isTreeLog;
    private static final List<Vector3f> SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});
    private static final List<Vector3f> ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        class_3111 config = (class_3111)featureConfig.method_33656();
        if (!world.method_8320(pos.method_10074()).method_26164(class_3481.field_21953)) {
            return false;
        }
        float size = MHelper.randRange((int)12, (int)20, (class_5819)random);
        int count = (int)(size * 0.3f);
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = MHelper.randRange((float)0.0f, (float)((float)Math.PI * 2), (class_5819)random);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + MHelper.randRange((float)0.0f, (float)var, (class_5819)random) + start;
            List spline = SplineHelper.copySpline(SPLINE);
            SplineHelper.rotateSpline((List)spline, (float)angle);
            SplineHelper.scale((List)spline, (float)(size * MHelper.randRange((float)0.5f, (float)1.0f, (class_5819)random)));
            SplineHelper.offsetParts((List)spline, (class_5819)random, (float)1.0f, (float)0.0f, (float)1.0f);
            SplineHelper.fillSpline((List)spline, (class_5281)world, (class_2680)EndBlocks.LUCERNIA.getBark().method_9564(), (class_2338)pos, REPLACE);
            Vector3f last = (Vector3f)spline.get(spline.size() - 1);
            float leavesRadius = (size * 0.13f + MHelper.randRange((float)0.8f, (float)1.5f, (class_5819)random)) * 1.4f;
            OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
            this.leavesBall(world, pos.method_10069((int)last.x(), (int)last.y(), (int)last.z()), leavesRadius, random, noise, config != null);
        }
        this.makeRoots(world, pos.method_10069(0, MHelper.randRange((int)3, (int)5, (class_5819)random), 0), size * 0.35f, random);
        return true;
    }

    private void leavesBall(class_5281 world, class_2338 pos, float radius, class_5819 random, OpenSimplexNoise noise, boolean natural) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((class_2680)EndBlocks.LUCERNIA_LEAVES.method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(6)));
        SDFUnary sub = new SDFScale().setScale(5.0f).setSource((SDF)sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource((SDF)sub);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.75f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 2.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(MHelper.randRange((float)-1.5f, (float)1.5f, (class_5819)random))).setSource((SDF)sphere);
        class_2338.class_2339 mut = new class_2338.class_2339();
        for (class_2350 d1 : BlocksHelper.HORIZONTAL) {
            class_2338 p = mut.method_10101((class_2382)pos).method_10098(class_2350.field_11036).method_10098(d1).method_10062();
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)p, (class_2680)EndBlocks.LUCERNIA.getBark().method_9564());
            for (class_2350 d2 : BlocksHelper.HORIZONTAL) {
                mut.method_10101((class_2382)p).method_10098(class_2350.field_11036).method_10098(d2);
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)p, (class_2680)EndBlocks.LUCERNIA.getBark().method_9564());
            }
        }
        class_2680 top = (class_2680)EndBlocks.FILALUX.method_9564().method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.TOP);
        class_2680 middle = (class_2680)EndBlocks.FILALUX.method_9564().method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE);
        class_2680 bottom = (class_2680)EndBlocks.FILALUX.method_9564().method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM);
        class_2680 outer = EndBlocks.LUCERNIA_OUTER_LEAVES.method_9564();
        ArrayList support = Lists.newArrayList();
        sphere.addPostProcess(info -> {
            if (natural && random.method_43048(6) == 0 && info.getStateDown().method_26215()) {
                class_2338 d = info.getPos().method_10074();
                support.add(d);
            }
            if (random.method_43048(15) == 0) {
                for (class_2338 class_23382 : class_2350.values()) {
                    class_2680 state = info.getState((class_2350)class_23382, 2);
                    if (!state.method_26215()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.LUCERNIA.getBark().method_9564());
            }
            MHelper.shuffle((Object[])DIRECTIONS, (class_5819)random);
            for (class_2338 class_23383 : DIRECTIONS) {
                if (!info.getState((class_2350)class_23383).method_26215()) continue;
                info.setBlockPos(info.getPos().method_10093((class_2350)class_23383), (class_2680)outer.method_11657((class_2769)FurBlock.FACING, (Comparable)class_23383));
            }
            if (EndBlocks.LUCERNIA.isTreeLog(info.getState())) {
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.method_33097(x + info.getPos().method_10263());
                    for (int z = -6; z < 7; ++z) {
                        int n = Math.abs(z);
                        mut.method_33099(z + info.getPos().method_10260());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + n;
                            if (d >= 7) continue;
                            mut.method_33098(y + info.getPos().method_10264());
                            class_2680 state = info.getState((class_2338)mut);
                            if (!(state.method_26204() instanceof class_2397) || d >= (distance = ((Integer)state.method_11654((class_2769)class_2397.field_11199)).intValue())) continue;
                            info.setState((class_2338)mut, (class_2680)state.method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((class_5425)world, pos, IGNORE);
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2248)EndBlocks.LUCERNIA.getBark());
        support.forEach(bpos -> {
            class_2680 state = world.method_8320(bpos);
            if (state.method_26215() || state.method_27852(EndBlocks.LUCERNIA_OUTER_LEAVES)) {
                int count = MHelper.randRange((int)3, (int)8, (class_5819)random);
                mut.method_10101((class_2382)bpos);
                if (world.method_8320(mut.method_10084()).method_27852(EndBlocks.LUCERNIA_LEAVES)) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)top);
                    for (int i = 1; i < count; ++i) {
                        mut.method_33098(mut.method_10264() - 1);
                        if (!world.method_22347(mut.method_10074())) break;
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)middle);
                    }
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)bottom);
                }
            }
        });
    }

    private void makeRoots(class_5281 world, class_2338 pos, float radius, class_5819 random) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (class_5819)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.method_8320(pos.method_10069((int)last.x(), (int)last.y(), (int)last.z())).method_26164(CommonBlockTags.GEN_END_STONES)) continue;
            SplineHelper.fillSplineForce((List)branch, (class_5281)world, (class_2680)EndBlocks.LUCERNIA.getBark().method_9564(), (class_2338)pos, REPLACE);
        }
    }

    static {
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
    }
}

