/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import journeymap.client.JourneymapClient;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.Waypoint;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class DrawWayPointStep
implements DrawStep {
    public final Waypoint waypoint;
    final Integer color;
    final Integer fontColor;
    final Texture texture;
    final boolean isEdit;
    Point2D.Double lastPosition;
    boolean lastOnScreen;
    boolean showLabel;
    double labelScale = 0.0;
    float iconScale = 0.0f;

    public DrawWayPointStep(Waypoint waypoint) {
        this(waypoint, waypoint.getIconColor(), waypoint.isDeathPoint() ? 0xFF0000 : waypoint.getSafeColor(), false);
    }

    public DrawWayPointStep(Waypoint waypoint, Integer color, Integer fontColor, boolean isEdit) {
        this.waypoint = waypoint;
        this.color = color;
        this.fontColor = fontColor;
        this.isEdit = isEdit;
        this.texture = waypoint.getTexture();
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setLabelScale(float labelScale) {
        this.labelScale = labelScale;
    }

    public void setIconScale(float iconScale) {
        this.iconScale = iconScale;
    }

    @Override
    public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
        if (!this.waypoint.isInPlayerDimension() || !JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) {
            return;
        }
        Point2D.Double pixel = this.getPosition(xOffset, yOffset, gridRenderer, true);
        if (gridRenderer.isOnScreen(pixel)) {
            if (this.showLabel && pass == DrawStep.Pass.Text) {
                int labelOffset = rotation == 0.0 ? -this.texture.getHeight() : this.texture.getHeight();
                labelOffset = this.iconScale <= 1.0f ? labelOffset : (int)((double)labelOffset + (double)((float)labelOffset * this.iconScale) * 0.2);
                this.labelScale = this.labelScale == 0.0 ? fontScale : this.labelScale;
                Point2D labelPoint = gridRenderer.shiftWindowPosition(pixel.getX(), pixel.getY(), 0, labelOffset);
                String waypointName = this.waypoint.getName();
                if (this.waypoint.isDeathPoint() && !JourneymapClient.getInstance().getWaypointProperties().showDeathpointlabel.get().booleanValue()) {
                    waypointName = "";
                }
                DrawUtil.drawBatchLabel(graphics.method_51448(), (class_2561)class_2561.method_43470((String)waypointName), buffers, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.7f, this.fontColor, 1.0f, this.labelScale, false, rotation);
            } else if (this.isEdit && pass == DrawStep.Pass.Object) {
                Texture editTex = TextureCache.getTexture(TextureCache.WaypointEdit);
                DrawUtil.drawWaypointIcon(graphics.method_51448(), editTex, this.iconScale, this.color, 1.0f, pixel.getX(), pixel.getY(), -rotation);
            }
            if (pass == DrawStep.Pass.Object) {
                DrawUtil.drawWaypointIcon(graphics.method_51448(), this.texture, this.iconScale, this.color, 1.0f, pixel.getX(), pixel.getY(), -rotation);
            }
        } else if (!this.isEdit && pass == DrawStep.Pass.Object) {
            gridRenderer.ensureOnScreen(pixel);
            DrawUtil.drawWaypointIcon(graphics.method_51448(), this.texture, this.iconScale, this.color, 1.0f, pixel.getX(), pixel.getY(), -rotation);
        }
    }

    public void drawOffscreen(class_4587 poseStack, DrawStep.Pass pass, Point2D pixel, double rotation) {
        if (pass == DrawStep.Pass.Object) {
            DrawUtil.drawWaypointIcon(poseStack, this.texture, this.iconScale, this.color, 1.0f, pixel.getX() - (double)(this.texture.getWidth() >> 1), pixel.getY() - (double)(this.texture.getHeight() >> 1), -rotation);
        }
    }

    public Point2D.Double getPosition(double xOffset, double yOffset, GridRenderer gridRenderer, boolean forceUpdate) {
        if (!forceUpdate && this.lastPosition != null) {
            return this.lastPosition;
        }
        double x = this.waypoint.getX();
        double z = this.waypoint.getZ();
        double halfBlock = Math.pow(2.0, gridRenderer.getZoom()) / 2.0;
        Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + halfBlock + xOffset, pixel.getY() + halfBlock + yOffset);
        this.lastPosition = pixel;
        return pixel;
    }

    public boolean isOnScreen() {
        return this.lastOnScreen;
    }

    public void setOnScreen(boolean lastOnScreen) {
        this.lastOnScreen = lastOnScreen;
    }

    @Override
    public int getDisplayOrder() {
        return 0;
    }

    @Override
    public String getModId() {
        return this.waypoint.getOrigin();
    }

    public static class SimpleCacheLoader
    extends CacheLoader<Waypoint, DrawWayPointStep> {
        public DrawWayPointStep load(Waypoint waypoint) throws Exception {
            return new DrawWayPointStep(waypoint);
        }
    }
}

