/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.nodes.AlternativesNode;
import com.yanny.ali.plugin.common.nodes.DynamicNode;
import com.yanny.ali.plugin.common.nodes.EmptyNode;
import com.yanny.ali.plugin.common.nodes.GroupNode;
import com.yanny.ali.plugin.common.nodes.ItemNode;
import com.yanny.ali.plugin.common.nodes.LootPoolNode;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.nodes.ReferenceNode;
import com.yanny.ali.plugin.common.nodes.SequenceNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_65;
import net.minecraft.class_67;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_69;
import net.minecraft.class_72;
import net.minecraft.class_73;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_83;
import net.minecraft.class_85;
import net.minecraft.class_91;
import net.minecraft.class_93;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class NodeUtils {
    @NotNull
    public static ItemNode getItemNode(IServerUtils utils, class_77 entry, float rawChance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        return NodeUtils.getItemNode(utils, (class_85)entry, f -> Either.left((Object)TooltipUtils.getItemStack(utils, entry.field_987.method_7854(), f)), rawChance, sumWeight, functions, conditions);
    }

    @NotNull
    public static ItemNode getTagNode(IServerUtils utils, class_91 entry, float rawChance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        return NodeUtils.getItemNode(utils, (class_85)entry, f -> Either.right((Object)entry.field_1005), rawChance, sumWeight, functions, conditions);
    }

    @NotNull
    public static ItemNode getItemNode(IServerUtils utils, class_85 entry, Function<List<class_117>, Either<class_1799, class_6862<? extends class_1935>>> itemGetter, float rawChance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        List<class_5341> allConditions = NodeUtils.getAllConditions((class_79)entry, conditions);
        List<class_117> allFunctions = NodeUtils.getAllFunctions(entry, functions);
        float chance = NodeUtils.getChance(entry, rawChance, sumWeight);
        RangeValue count = NodeUtils.getEnchantedCount(utils, allFunctions).get(null).get(0);
        Map<class_1887, Map<Integer, RangeValue>> enchantedChance = NodeUtils.getEnchantedChance(utils, allConditions, chance);
        Map<class_1887, Map<Integer, RangeValue>> enchantedCount = NodeUtils.getEnchantedCount(utils, allFunctions);
        ITooltipNode tooltip = EntryTooltipUtils.getTooltip(utils, entry.field_994, enchantedChance, enchantedCount, allFunctions, allConditions);
        return new ItemNode(chance, count, itemGetter.apply(allFunctions), tooltip, allFunctions, allConditions);
    }

    @NotNull
    public static AlternativesNode getAlternativesNode(IServerUtils utils, class_65 entry, float rawChance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        List<class_5341> allConditions = NodeUtils.getAllConditions((class_79)entry, conditions);
        List<IDataNode> children = NodeUtils.getChildren(utils, entry.field_982, rawChance, sumWeight, functions, allConditions);
        ITooltipNode tooltip = EntryTooltipUtils.getAlternativesTooltip();
        return new AlternativesNode(children, tooltip);
    }

    @NotNull
    public static DynamicNode getDynamicNode(IServerUtils utils, class_67 entry, float rawChance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        List<class_117> allFunctions = NodeUtils.getAllFunctions((class_85)entry, functions);
        List<class_5341> allConditions = NodeUtils.getAllConditions((class_79)entry, conditions);
        float chance = NodeUtils.getChance((class_85)entry, rawChance, sumWeight);
        ITooltipNode tooltip = EntryTooltipUtils.getDynamicTooltip(utils, entry.field_994, chance, allFunctions, allConditions);
        return new DynamicNode(chance, tooltip);
    }

    @NotNull
    public static EmptyNode getEmptyNode(IServerUtils utils, class_73 entry, float rawChance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        List<class_117> allFunctions = NodeUtils.getAllFunctions((class_85)entry, functions);
        List<class_5341> allConditions = NodeUtils.getAllConditions((class_79)entry, conditions);
        float chance = NodeUtils.getChance((class_85)entry, rawChance, sumWeight);
        Map<class_1887, Map<Integer, RangeValue>> enchantedChance = NodeUtils.getEnchantedChance(utils, allConditions, chance);
        ITooltipNode tooltip = EntryTooltipUtils.getEmptyTooltip(utils, entry.field_994, enchantedChance, allFunctions, allConditions);
        return new EmptyNode(chance, tooltip);
    }

    @NotNull
    public static GroupNode getGroupNode(IServerUtils utils, class_93 entry, float rawChance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        List<class_5341> allConditions = NodeUtils.getAllConditions((class_79)entry, conditions);
        List<IDataNode> children = NodeUtils.getChildren(utils, entry.field_982, rawChance, sumWeight, functions, allConditions);
        ITooltipNode tooltip = EntryTooltipUtils.getGroupTooltip();
        return new GroupNode(children, tooltip);
    }

    @NotNull
    public static SequenceNode getSequenceNode(IServerUtils utils, class_72 entry, float rawChance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        List<class_5341> allConditions = NodeUtils.getAllConditions((class_79)entry, conditions);
        List<IDataNode> children = NodeUtils.getChildren(utils, entry.field_982, rawChance, sumWeight, functions, allConditions);
        ITooltipNode tooltip = EntryTooltipUtils.getSequentialTooltip();
        return new SequenceNode(children, tooltip);
    }

    @NotNull
    public static ReferenceNode getReferenceNode(IServerUtils utils, class_83 entry, float rawChance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        List<class_117> allFunctions = NodeUtils.getAllFunctions((class_85)entry, functions);
        List<class_5341> allConditions = NodeUtils.getAllConditions((class_79)entry, conditions);
        float chance = NodeUtils.getChance((class_85)entry, rawChance, sumWeight);
        class_52 lootTable = utils.getLootTable(entry.field_993);
        ITooltipNode tooltip = EntryTooltipUtils.getReferenceTooltip(entry, rawChance, sumWeight);
        List<IDataNode> children = lootTable != null ? Collections.singletonList(NodeUtils.getLootTableNode(Collections.emptyList(), utils, lootTable, chance, allFunctions, allConditions)) : Collections.singletonList(new MissingNode(utils.getValueTooltip(utils, entry.field_993).build("ali.property.value.loot_table")));
        return new ReferenceNode(children, chance, tooltip);
    }

    @NotNull
    public static ReferenceNode getReferenceNode(IServerUtils utils, class_2960 table, List<class_5341> conditions, ITooltipNode tooltip) {
        class_52 lootTable = utils.getLootTable(table);
        List<IDataNode> children = lootTable != null ? Collections.singletonList(NodeUtils.getLootTableNode(Collections.emptyList(), utils, lootTable, 1.0f, Collections.emptyList(), conditions)) : Collections.singletonList(new MissingNode(utils.getValueTooltip(utils, table).build("ali.property.value.loot_table")));
        return new ReferenceNode(children, 1.0f, tooltip);
    }

    @NotNull
    public static LootPoolNode getLootPoolNode(IServerUtils utils, class_55 entry, float rawChance, List<class_117> functions, List<class_5341> conditions) {
        List<class_117> allFunctions = Stream.concat(functions.stream(), Arrays.stream(entry.field_956)).toList();
        List<class_5341> allConditions = Stream.concat(conditions.stream(), Arrays.stream(entry.field_954)).toList();
        int sumWeight = NodeUtils.getTotalWeight(Arrays.asList(entry.field_953));
        ITooltipNode tooltip = EntryTooltipUtils.getLootPoolTooltip(utils.convertNumber(utils, entry.field_957), utils.convertNumber(utils, entry.field_958));
        List<IDataNode> children = NodeUtils.getChildren(utils, entry.field_953, rawChance, sumWeight, allFunctions, allConditions);
        return new LootPoolNode(children, tooltip);
    }

    @NotNull
    public static LootTableNode getLootTableNode(List<ILootModifier<?>> modifiers) {
        ITooltipNode tooltip = EntryTooltipUtils.getLootTableTooltip();
        ArrayList<IDataNode> children = new ArrayList<IDataNode>();
        LootTableNode node = new LootTableNode(children, tooltip);
        for (ILootModifier<?> modifier : modifiers) {
            NodeUtils.processLootModifier(modifier, node);
        }
        return node;
    }

    @NotNull
    public static LootTableNode getLootTableNode(List<ILootModifier<?>> modifiers, IServerUtils utils, class_52 entry, float rawChance, List<class_117> functions, List<class_5341> conditions) {
        List<class_117> allFunctions = Stream.concat(functions.stream(), Arrays.stream(entry.field_944)).toList();
        ITooltipNode tooltip = EntryTooltipUtils.getLootTableTooltip();
        List<IDataNode> children = utils.getLootPools(entry).stream().map(lootPool -> NodeUtils.getLootPoolNode(utils, lootPool, rawChance, allFunctions, conditions)).toList();
        LootTableNode node = new LootTableNode(children, tooltip);
        for (ILootModifier<?> modifier : modifiers) {
            NodeUtils.processLootModifier(modifier, node);
        }
        return node;
    }

    public static float getChance(class_85 entry, float rawChance, int sumWeight) {
        return rawChance * (float)entry.field_995 / (float)sumWeight;
    }

    public static @Unmodifiable @NotNull List<class_5341> getAllConditions(class_79 entry, List<class_5341> conditions) {
        return Stream.concat(conditions.stream(), Arrays.stream(entry.field_988)).toList();
    }

    public static @Unmodifiable @NotNull List<class_117> getAllFunctions(class_85 entry, List<class_117> functions) {
        return Stream.concat(functions.stream(), Arrays.stream(entry.field_996)).toList();
    }

    @NotNull
    public static List<IDataNode> getChildren(IServerUtils utils, class_79[] children, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        return Arrays.stream(children).map(c -> utils.getEntryFactory(utils, c).create(utils, (class_79)c, chance, sumWeight, functions, conditions)).toList();
    }

    @NotNull
    public static Map<class_1887, Map<Integer, RangeValue>> getEnchantedChance(IServerUtils utils, List<class_5341> conditions, float rawChance) {
        LinkedHashMap<class_1887, Map<Integer, RangeValue>> chance = new LinkedHashMap<class_1887, Map<Integer, RangeValue>>();
        chance.put(null, Map.of(0, new RangeValue(rawChance * 100.0f)));
        for (class_5341 condition : conditions) {
            utils.applyChanceModifier(utils, condition, chance);
        }
        return chance;
    }

    @NotNull
    public static Map<class_1887, Map<Integer, RangeValue>> getEnchantedCount(IServerUtils utils, List<class_117> functions) {
        LinkedHashMap<class_1887, Map<Integer, RangeValue>> count = new LinkedHashMap<class_1887, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue()));
        for (class_117 function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    public static int getTotalWeight(List<class_79> entries) {
        int sum = 0;
        for (class_79 entry : entries) {
            if (entry instanceof class_85) {
                class_85 singletonContainer = (class_85)entry;
                sum += singletonContainer.field_995;
                continue;
            }
            if (!(entry instanceof class_69)) continue;
            class_69 compositeEntryBase = (class_69)entry;
            if (entry instanceof class_65) {
                ++sum;
                continue;
            }
            sum += NodeUtils.getTotalWeight(Arrays.asList(compositeEntryBase.field_982));
        }
        return sum;
    }

    @NotNull
    public static List<class_2561> toComponents(List<ITooltipNode> tooltip, int pad, boolean showAdvancedTooltip) {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        for (ITooltipNode node : tooltip) {
            components.addAll(NodeUtils.toComponents(node, pad, showAdvancedTooltip));
        }
        return components;
    }

    @NotNull
    public static List<class_2561> toComponents(ITooltipNode tooltip, int pad, boolean showAdvancedTooltip) {
        return tooltip.getComponents(pad, showAdvancedTooltip);
    }

    public static void processLootModifier(ILootModifier<?> modifier, LootTableNode node) {
        List<IOperation> operations = modifier.getOperations();
        for (IOperation operation : operations) {
            if (operation instanceof IOperation.AddOperation) {
                IOperation.AddOperation addOperation = (IOperation.AddOperation)operation;
                node.addChildren(addOperation.node());
                continue;
            }
            if (operation instanceof IOperation.RemoveOperation) {
                IOperation.RemoveOperation removeOperation = (IOperation.RemoveOperation)operation;
                NodeUtils.removeItem(node, removeOperation.predicate());
                continue;
            }
            if (!(operation instanceof IOperation.ReplaceOperation)) continue;
            IOperation.ReplaceOperation replaceOperation = (IOperation.ReplaceOperation)operation;
            NodeUtils.replaceItem(node, replaceOperation.factory(), replaceOperation.predicate());
        }
    }

    private static void removeItem(IDataNode node, Predicate<class_1799> predicate) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            listNode.nodes().removeIf(n -> {
                if (n instanceof IItemNode) {
                    IItemNode itemNode = (IItemNode)((Object)n);
                    return NodeUtils.predicateEither(itemNode, predicate);
                }
                NodeUtils.removeItem(n, predicate);
                return false;
            });
            NodeUtils.removeEmptyNodes(node);
        }
    }

    private static void replaceItem(IDataNode node, Function<IDataNode, List<IDataNode>> factory, Predicate<class_1799> predicate) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            ArrayList nodes = new ArrayList();
            listNode.nodes().replaceAll(n -> {
                IItemNode itemNode;
                if (n instanceof IItemNode && NodeUtils.predicateEither(itemNode = (IItemNode)((Object)n), predicate)) {
                    List result = (List)factory.apply((IDataNode)n);
                    if (result.size() > 1) {
                        nodes.addAll(result.subList(1, result.size()));
                    }
                    return (IDataNode)result.get(0);
                }
                if (n instanceof ListNode) {
                    ListNode l = (ListNode)n;
                    NodeUtils.replaceItem(l, factory, predicate);
                }
                return n;
            });
            nodes.forEach(listNode::addChildren);
        }
    }

    private static boolean hasItems(IDataNode node) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            return listNode.nodes().stream().anyMatch(NodeUtils::hasItems);
        }
        return node instanceof IItemNode;
    }

    private static void removeEmptyNodes(IDataNode node) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            listNode.nodes().removeIf(n -> !NodeUtils.hasItems(n));
        }
    }

    private static <T extends class_1935> boolean predicateEither(IItemNode itemNode, Predicate<class_1799> predicate) {
        return (Boolean)itemNode.getModifiedItem().map(predicate::test, tagKey -> {
            class_2378 registry = (class_2378)class_7923.field_41167.method_10223(tagKey.comp_326().method_29177());
            if (registry != null) {
                return registry.method_40266(tagKey).map(holders -> holders.method_40239().map(class_6880::comp_349)).orElse(Stream.of(new class_1935[0])).map(i -> i.method_8389().method_7854()).allMatch(predicate);
            }
            return false;
        });
    }
}

