/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client.widget.trades;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.client.WidgetUtils;
import com.yanny.ali.plugin.client.widget.ItemWidget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class ItemListingWidget
implements IWidget {
    private final List<IWidget> widgets;
    private final RelativeRect bounds;

    public ItemListingWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        ListNode node = (ListNode)entry;
        this.widgets = new ArrayList<IWidget>();
        this.addWidget(utils, rect, node.nodes().get(0), 0, maxWidth);
        this.addWidget(utils, rect, node.nodes().get(1), 20, maxWidth);
        this.widgets.add(WidgetUtils.getArrowWidget(new RelativeRect(40, 0, 24, 18, rect), entry));
        this.addWidget(utils, rect, node.nodes().get(2), 66, maxWidth);
        this.bounds = rect;
        this.bounds.setDimensions(maxWidth, 18);
    }

    @Override
    public RelativeRect getRect() {
        return this.bounds;
    }

    @Override
    public WidgetDirection getDirection() {
        return WidgetDirection.VERTICAL;
    }

    @Override
    public List<class_2561> getTooltipComponents(int mouseX, int mouseY) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        for (IWidget widget : this.widgets) {
            RelativeRect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            components.addAll(widget.getTooltipComponents(mouseX, mouseY));
        }
        return components;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = false;
        for (IWidget widget : this.widgets) {
            RelativeRect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            clicked |= widget.mouseClicked(mouseX, mouseY, button);
        }
        return clicked;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY) {
        for (IWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY);
        }
    }

    private void addWidget(IWidgetUtils utils, RelativeRect rect, IDataNode node, int offsetX, int maxWidth) {
        this.widgets.add(new ItemWidget(utils, node, new RelativeRect(offsetX, 0, 18, 18, rect), maxWidth));
    }
}

