/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.lootjs.node;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_117;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class ItemTagNode
implements IDataNode,
IItemNode {
    public static final class_2960 ID = new class_2960("lootjs", "item_tag");
    private final ITooltipNode tooltip;
    private final List<class_5341> conditions;
    private final List<class_117> functions;
    private final class_6862<? extends class_1935> tag;
    private final RangeValue count;
    private final float chance;
    private final boolean modified;

    public ItemTagNode(IServerUtils utils, class_6862<? extends class_1935> entry, float chance, List<class_117> functions, List<class_5341> conditions, boolean preserveCount) {
        this(utils, entry, chance, false, functions, conditions, preserveCount);
    }

    public ItemTagNode(IServerUtils utils, class_6862<? extends class_1935> entry, float chance, boolean modified, List<class_117> functions, List<class_5341> conditions, boolean preserveCount) {
        this.conditions = conditions;
        this.functions = functions;
        this.tag = entry;
        this.chance = chance;
        this.modified = modified;
        if (preserveCount) {
            this.tooltip = ItemTagNode.getItemTooltip(utils, chance, functions, conditions);
            this.count = ItemTagNode.getCount(utils, 1, functions).get(null).get(0);
        } else {
            this.tooltip = ItemTagNode.getItemTooltip(utils, chance, Collections.emptyList(), Collections.emptyList());
            this.count = ItemTagNode.getCount(utils, 1, Collections.emptyList()).get(null).get(0);
        }
    }

    public ItemTagNode(IClientUtils utils, class_2540 buf) {
        this.tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)buf.method_10810());
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.count = new RangeValue(buf);
        this.modified = buf.readBoolean();
        this.chance = buf.readFloat();
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public Either<class_1799, class_6862<? extends class_1935>> getModifiedItem() {
        return Either.right(this.tag);
    }

    @Override
    public List<class_5341> getConditions() {
        return this.conditions;
    }

    @Override
    public List<class_117> getFunctions() {
        return this.functions;
    }

    @Override
    @NotNull
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, class_2540 buf) {
        buf.method_10812(this.tag.comp_327());
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        this.count.encode(buf);
        buf.writeBoolean(this.modified);
        buf.writeFloat(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @NotNull
    private static ITooltipNode getItemTooltip(IServerUtils utils, float chance, List<class_117> functions, List<class_5341> conditions) {
        Map<class_1887, Map<Integer, RangeValue>> chanceMap = NodeUtils.getEnchantedChance(utils, conditions, chance);
        Map<class_1887, Map<Integer, RangeValue>> countMap = ItemTagNode.getCount(utils, 1, functions);
        return EntryTooltipUtils.getTooltip(utils, 0, chanceMap, countMap, functions, conditions);
    }

    @NotNull
    public static Map<class_1887, Map<Integer, RangeValue>> getCount(IServerUtils utils, int baseCount, List<class_117> functions) {
        LinkedHashMap<class_1887, Map<Integer, RangeValue>> count = new LinkedHashMap<class_1887, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue(baseCount)));
        for (class_117 function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }
}

