/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.fabric.plugin.mods.porting_lib.loot;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.fabric.plugin.mods.porting_lib.loot.IGlmPlugin;
import com.yanny.ali.fabric.plugin.mods.porting_lib.loot.LootModifier;
import com.yanny.ali.fabric.plugin.mods.porting_lib.loot.LootModifierManager;
import com.yanny.ali.fabric.plugin.mods.porting_lib.loot.LootTableIdCondition;
import com.yanny.ali.platform.Services;
import com.yanny.ali.plugin.glm.GlobalLootModifierUtils;
import com.yanny.ali.plugin.glm.IGlobalLootModifierPlugin;
import com.yanny.ali.plugin.glm.IGlobalLootModifierWrapper;
import com.yanny.ali.plugin.glm.ILootTableIdConditionPredicate;
import com.yanny.ali.plugin.mods.PluginUtils;
import com.yanny.ali.plugin.mods.ReflectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_2960;
import net.minecraft.class_5341;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@AliEntrypoint
public class Plugin
implements IPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Class<?> LOOT_MODIFIER_CLASS;
    private static Class<?> LOOT_TABLE_ID_CONDITION_CLASS;

    @Override
    public String getModId() {
        return "porting_lib_loot";
    }

    @Override
    public void registerServer(IServerRegistry registry) {
        PluginUtils.registerConditionTooltip(registry, LootTableIdCondition.class);
        registry.registerLootModifiers(Plugin::registerLootModifiers);
    }

    @NotNull
    private static List<ILootModifier<?>> registerLootModifiers(IServerUtils utils) {
        HashMap glmMap = new HashMap();
        HashSet missingGLM = new HashSet();
        ArrayList lootModifiers = new ArrayList();
        ILootTableIdConditionPredicate tablePredicate = Plugin.getLootTableIdConditionPredicate();
        IGlobalLootModifierPlugin.IRegistry forgeRegistry = Plugin.getRegistry(glmMap);
        for (IPlugin iPlugin : Services.getPlatform().getPlugins()) {
            if (!(iPlugin instanceof IGlmPlugin)) continue;
            IGlmPlugin glmPlugin = (IGlmPlugin)iPlugin;
            glmPlugin.registerGlobalLootModifier(forgeRegistry, tablePredicate);
        }
        for (Map.Entry entry : LootModifierManager.getAllLootMods().entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            Object globalLootModifier = entry.getValue();
            IGlobalLootModifierWrapper wrapper = Plugin.wrap(globalLootModifier, location);
            try {
                BiFunction getter = (BiFunction)glmMap.get(globalLootModifier.getClass());
                if (getter != null) {
                    Optional lootModifier = (Optional)getter.apply(utils, globalLootModifier);
                    if (lootModifier.isPresent()) {
                        lootModifiers.add((ILootModifier)lootModifier.get());
                        continue;
                    }
                    LOGGER.warn("Unable to locate destination for GLM {}", (Object)wrapper.getName());
                    continue;
                }
                Optional<ILootModifier<?>> modifier = GlobalLootModifierUtils.getMissingGlobalLootModifier(utils, wrapper, tablePredicate);
                missingGLM.add(globalLootModifier.getClass());
                if (modifier.isPresent()) {
                    lootModifiers.add(modifier.get());
                    continue;
                }
                LOGGER.warn("Unable to locate destination for auto GLM {}", (Object)wrapper.getName());
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.warn("Failed to add GLM with error {}", (Object)e.getMessage());
            }
        }
        missingGLM.forEach(c -> LOGGER.warn("Missing GLM for {}", (Object)c.getName()));
        return lootModifiers;
    }

    @NotNull
    private static ILootTableIdConditionPredicate getLootTableIdConditionPredicate() {
        return new ILootTableIdConditionPredicate(){

            @Override
            public boolean isLootTableIdCondition(class_5341 condition) {
                return LOOT_TABLE_ID_CONDITION_CLASS.isAssignableFrom(condition.getClass());
            }

            @Override
            public class_2960 getTargetLootTableId(class_5341 condition) {
                return ReflectionUtils.copyClassData(LootTableIdCondition.class, condition).getTargetLootTableId();
            }
        };
    }

    @NotNull
    private static IGlobalLootModifierWrapper wrap(final Object modifier, final class_2960 location) {
        return new IGlobalLootModifierWrapper(){

            @Override
            public class_2960 getName() {
                return location;
            }

            @Override
            public Class<?> getLootModifierClass() {
                return LOOT_MODIFIER_CLASS;
            }

            @Override
            public boolean isLootModifier() {
                return LOOT_MODIFIER_CLASS.isAssignableFrom(modifier.getClass());
            }

            @Override
            public List<class_5341> getConditions() {
                return Arrays.asList(((LootModifier)modifier).getConditions());
            }
        };
    }

    @NotNull
    private static IGlobalLootModifierPlugin.IRegistry getRegistry(final Map<Class<?>, BiFunction<IServerUtils, Object, Optional<ILootModifier<?>>>> glmMap) {
        return new IGlobalLootModifierPlugin.IRegistry(){

            @Override
            public <T> void registerGlobalLootModifier(Class<T> type, BiFunction<IServerUtils, T, Optional<ILootModifier<?>>> getter) {
                glmMap.put(type, (u, t) -> (Optional)getter.apply((IServerUtils)u, (Object)t));
            }
        };
    }

    static {
        try {
            LOOT_MODIFIER_CLASS = Class.forName("io.github.fabricators_of_create.porting_lib.loot.LootModifier");
            LOOT_TABLE_ID_CONDITION_CLASS = Class.forName("io.github.fabricators_of_create.porting_lib.loot.LootTableIdCondition");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain GLM classes: {}", (Object)e.getMessage());
        }
    }
}

