/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.compat.toughasnails.ToughAsNailsPotionEffect;
import com.tiviacz.travelersbackpack.compat.toughasnails.ToughAsNailsWaterCanteenEffect;
import com.tiviacz.travelersbackpack.compat.toughasnails.ToughAsNailsWaterEffect;
import com.tiviacz.travelersbackpack.fluids.effects.LavaEffect;
import com.tiviacz.travelersbackpack.fluids.effects.MilkEffect;
import com.tiviacz.travelersbackpack.fluids.effects.PotionEffect;
import com.tiviacz.travelersbackpack.fluids.effects.WaterEffect;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3611;

public class EffectFluidRegistry {
    public static BiMap<String, EffectFluid> EFFECT_REGISTRY = HashBiMap.create();
    public static EffectFluid WATER_EFFECT;
    public static EffectFluid LAVA_EFFECT;
    public static EffectFluid POTION_EFFECT;
    public static EffectFluid MILK_EFFECT;
    public static EffectFluid TAN_POTION_EFFECT;
    public static EffectFluid TAN_WATER_CANTEEN_EFFECT;
    public static EffectFluid TAN_WATER_EFFECT;
    private static int effectIDCounter;

    public static void initEffects() {
        EFFECT_REGISTRY.clear();
        WATER_EFFECT = new WaterEffect();
        LAVA_EFFECT = new LavaEffect();
        POTION_EFFECT = new PotionEffect("travelersbackpack:potion", (class_3611)ModFluids.POTION_STILL);
        MILK_EFFECT = new MilkEffect();
        if (TravelersBackpack.toughasnailsLoaded) {
            TAN_POTION_EFFECT = new ToughAsNailsPotionEffect();
            TAN_WATER_CANTEEN_EFFECT = new ToughAsNailsWaterCanteenEffect();
            TAN_WATER_EFFECT = new ToughAsNailsWaterEffect();
        }
    }

    public static int registerFluidEffect(EffectFluid effect) {
        String uniqueId = effect.getUniqueId();
        if (!EFFECT_REGISTRY.containsKey((Object)uniqueId) && effect.fluid != null) {
            EFFECT_REGISTRY.put((Object)uniqueId, (Object)effect);
            effect.setEffectID(effectIDCounter);
            LogHelper.info("Registered the FluidEffect with Unique ID of " + uniqueId + " for " + EffectFluidRegistry.getFluidName(effect) + " (Fluid Amount Required: " + effect.amountRequired + ") with the ID " + effectIDCounter, new Object[0]);
            return ++effectIDCounter;
        }
        return -1;
    }

    public static String getFluidName(EffectFluid effect) {
        return Optional.ofNullable(effect).map(e -> e.fluid).map(FluidVariant::of).map(FluidTypeHelper::getFluidVariantName).map(class_2561::getString).orElse("Unknown Fluid");
    }

    public static Map<String, EffectFluid> getRegisteredFluidEffects() {
        return ImmutableMap.copyOf(EFFECT_REGISTRY);
    }

    public static int getHighestFluidEffectAmount(class_3611 fluid) {
        int amount = 0;
        for (EffectFluid effect : EffectFluidRegistry.getEffectsForFluid(fluid)) {
            if (effect.amountRequired <= amount) continue;
            amount = effect.amountRequired;
        }
        return amount;
    }

    public static ArrayList<EffectFluid> getEffectsForFluid(class_3611 fluid) {
        ArrayList<EffectFluid> effectsForFluid = new ArrayList<EffectFluid>();
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            if (fluid != effect.fluid) continue;
            effectsForFluid.add(effect);
        }
        return effectsForFluid;
    }

    public static boolean hasEffects(FluidVariantWrapper fluid) {
        ArrayList<EffectFluid> effects = EffectFluidRegistry.getEffectsForFluid(fluid.fluidVariant().getFluid());
        return !effects.isEmpty();
    }

    public static boolean hasExecutableEffects(FluidVariantWrapper fluid, class_1937 level, class_1297 entity) {
        List<EffectFluid> executableEffects = EffectFluidRegistry.getExecutableEffects(fluid, level, entity);
        return !executableEffects.isEmpty();
    }

    public static List<EffectFluid> getExecutableEffects(FluidVariantWrapper fluid, class_1937 level, class_1297 entity) {
        ArrayList<EffectFluid> executableEffects = new ArrayList<EffectFluid>();
        for (EffectFluid effect : EffectFluidRegistry.getEffectsForFluid(fluid.fluidVariant().getFluid())) {
            if (!effect.canExecuteEffect(fluid, level, entity)) continue;
            executableEffects.add(effect);
        }
        return executableEffects;
    }

    public static boolean executeEffects(FluidVariantWrapper fluid, class_1297 entity, class_1937 level) {
        for (EffectFluid effect : EffectFluidRegistry.getExecutableEffects(fluid, level, entity)) {
            effect.affectDrinker(fluid, level, entity);
        }
        return true;
    }

    public static boolean canInitialize(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    static {
        effectIDCounter = 0;
    }
}

