/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.BlockLogicUtil;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldBossRoom;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldIsland;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldStub;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldStubCave;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldTunnel;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6624;
import net.minecraft.class_6626;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;

public class GoldDungeonStructure
extends class_3195 {
    public static final Codec<GoldDungeonStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)GoldDungeonStructure.method_42697((RecordCodecBuilder.Instance)builder), (App)Codec.INT.fieldOf("stubcount").forGetter(o -> o.stubIslandCount), (App)Codec.INT.fieldOf("belowTerrain").forGetter(o -> o.belowTerrain), (App)Codec.INT.fieldOf("minY").forGetter(o -> o.minY), (App)Codec.INT.fieldOf("rangeY").forGetter(o -> o.rangeY), (App)class_6796.field_35730.fieldOf("islandFoliage").forGetter(p_204928_ -> p_204928_.islandFoliage), (App)class_6796.field_35730.fieldOf("stubFoliage").forGetter(p_204928_ -> p_204928_.stubFoliage)).apply((Applicative)builder, GoldDungeonStructure::new));
    private final int stubIslandCount;
    private final int belowTerrain;
    private final int minY;
    private final int rangeY;
    private final class_6880<class_6796> islandFoliage;
    private final class_6880<class_6796> stubFoliage;

    public GoldDungeonStructure(class_3195.class_7302 settings, int stubIslandCount, int belowTerrain, int minY, int rangeY, class_6880<class_6796> islandFoliage, class_6880<class_6796> stubFoliage) {
        super(settings);
        this.stubIslandCount = stubIslandCount;
        this.belowTerrain = belowTerrain;
        this.minY = minY;
        this.rangeY = rangeY;
        this.islandFoliage = islandFoliage;
        this.stubFoliage = stubFoliage;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2919 random = context.comp_566();
        class_1923 chunkpos = context.comp_568();
        int x = chunkpos.method_33940();
        int z = chunkpos.method_33942();
        int terrainHeight = context.comp_562().method_16397(x, z, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()) - this.belowTerrain;
        int height = this.minY + random.method_43048(this.rangeY);
        height = Math.max(terrainHeight, height);
        class_2338 blockpos = new class_2338(chunkpos.method_33940(), height, chunkpos.method_33942());
        return Optional.of(new class_3195.class_7150(blockpos, piecesBuilder -> this.generatePieces((class_6626)piecesBuilder, context, blockpos)));
    }

    private void generatePieces(class_6626 builder, class_3195.class_7149 context, class_2338 elevatedPos) {
        class_2919 random = context.comp_566();
        class_3485 templateManager = context.comp_565();
        GoldIsland island = new GoldIsland(templateManager, "island", elevatedPos);
        builder.method_35462((class_3443)island);
        class_2338 centerPos = island.method_14935().method_22874();
        class_2382 stubOffset = this.getStubOffset(templateManager);
        this.addIslandStubs(templateManager, builder, (class_5819)random, centerPos, stubOffset);
        this.placeGumdropCaves(builder, (class_5819)random, centerPos);
        class_2470 rotation = class_2470.method_16548((class_5819)random);
        class_2338 bossPos = centerPos.method_10081(this.getBossRoomOffset(templateManager, rotation.method_10503(class_2350.field_11035)));
        GoldBossRoom bossRoom = new GoldBossRoom(templateManager, "boss_room", bossPos, rotation);
        int verticalOffset = this.tunnelFromBossRoom(templateManager, builder, (class_3443)bossRoom, context.comp_562(), context.comp_569(), context.comp_564());
        builder.method_35462((class_3443)bossRoom);
        if (verticalOffset > 0) {
            builder.method_38715(verticalOffset);
        }
    }

    private void addIslandStubs(class_3485 templateManager, class_6626 builder, class_5819 random, class_2338 center, class_2382 stubOffset) {
        int stubCount = this.stubIslandCount + random.method_43048(5);
        for (int stubIslands = 0; stubIslands < stubCount; ++stubIslands) {
            float angle = random.method_43057() * ((float)Math.PI * 2);
            float distance = (random.method_43057() * 0.125f + 0.7f) * 24.0f;
            int xOffset = class_3532.method_15357((double)(Math.cos(angle) * (double)distance));
            int yOffset = -class_3532.method_15357((double)(24.0 * (double)random.method_43057() * 0.3));
            int zOffset = class_3532.method_15357((double)(-Math.sin(angle) * (double)distance));
            class_2338 stubPos = center.method_10069(xOffset, yOffset, zOffset);
            stubPos = stubPos.method_10081(stubOffset);
            GoldStub stub = new GoldStub(templateManager, "stub", stubPos);
            builder.method_35462((class_3443)stub);
        }
    }

    private void placeGumdropCaves(class_6626 builder, class_5819 random, class_2338 center) {
        for (int count = 0; count < 18; ++count) {
            int x = center.method_10263() + random.method_43048(24) - random.method_43048(24);
            int y = center.method_10264() + random.method_43048(24) - random.method_43048(24);
            int z = center.method_10260() + random.method_43048(24) - random.method_43048(24);
            builder.method_35462((class_3443)new GoldStubCave(new class_3341(new class_2338(x, y, z))));
        }
    }

    private int tunnelFromBossRoom(class_3485 templateManager, class_6626 builder, class_3443 room, class_2794 chunkGenerator, class_5539 heightAccessor, class_7138 randomState) {
        class_3499 template = templateManager.method_15091(new class_2960("aether", "gold_dungeon/tunnel"));
        int width = template.method_15160().method_10263();
        class_2470 rotation = room.method_16888();
        class_2350 direction = rotation.method_10503(class_2350.field_11035);
        class_2338 startPos = BlockLogicUtil.tunnelFromOddSquareRoom(room.method_14935(), direction, width);
        startPos = startPos.method_10069(direction.method_10148() * 3, 1, direction.method_10165() * 3);
        GoldTunnel tunnel = new GoldTunnel(templateManager, "tunnel", startPos, rotation);
        builder.method_35462((class_3443)tunnel);
        class_2338 endPos = BlockLogicUtil.tunnelFromEvenSquareRoom(tunnel.method_14935(), direction, tunnel.method_41624().method_15160().method_10263());
        return chunkGenerator.method_20402(endPos.method_10263(), endPos.method_10260(), class_2902.class_2903.field_13194, heightAccessor, randomState) - startPos.method_10264();
    }

    private class_2382 getStubOffset(class_3485 templateManager) {
        class_3499 template = templateManager.method_15091(new class_2960("aether", "gold_dungeon/stub"));
        class_2382 size = template.method_15160();
        return new class_2382(size.method_10263() / -2, size.method_10264() / -2, size.method_10260() / -2);
    }

    private class_2382 getBossRoomOffset(class_3485 templateManager, class_2350 direction) {
        class_3499 template = templateManager.method_15091(new class_2960("aether", "gold_dungeon/boss_room"));
        class_2382 size = template.method_15160();
        class_2382 offset = new class_2382(size.method_10263() / -2, size.method_10264() / -2, size.method_10260() / -2);
        return offset.method_23226(direction, -1);
    }

    public void method_38694(class_5281 level, class_5138 structureManager, class_2794 generator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_6624 pieces) {
        for (class_3443 piece : pieces.comp_132()) {
            if (piece instanceof GoldIsland) {
                GoldIsland island = (GoldIsland)piece;
                GoldDungeonStructure.placeGoldenOaks(level, generator, random, island.method_14935(), chunkBox, this.islandFoliage);
                continue;
            }
            if (!(piece instanceof GoldStub)) continue;
            GoldStub stub = (GoldStub)piece;
            GoldDungeonStructure.placeGoldenOaks(level, generator, random, stub.method_14935(), chunkBox, this.stubFoliage);
        }
    }

    private static void placeGoldenOaks(class_5281 level, class_2794 generator, class_5819 random, class_3341 boundingBox, class_3341 chunkBox, class_6880<class_6796> feature) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int minX = Math.max(chunkBox.method_35415(), boundingBox.method_35415());
        int minZ = Math.max(chunkBox.method_35417(), boundingBox.method_35417());
        int maxX = Math.min(chunkBox.method_35418(), boundingBox.method_35418());
        int maxZ = Math.min(chunkBox.method_35420(), boundingBox.method_35420());
        int minY = boundingBox.method_35416() + class_3532.method_15357((double)((double)(boundingBox.method_35419() - boundingBox.method_35416()) * 0.75));
        int maxY = boundingBox.method_35419();
        class_6796 placement = (class_6796)feature.comp_349();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                mutable.method_10103(x, maxY, z);
                if (!GoldDungeonStructure.iterateColumn(level, mutable, minY, maxY)) continue;
                placement.method_39644(level, generator, random, (class_2338)mutable);
            }
        }
    }

    private static boolean iterateColumn(class_5281 level, class_2338.class_2339 pos, int minY, int maxY) {
        for (int y = maxY; y > minY; --y) {
            pos.method_33098(y);
            if (!level.method_8320((class_2338)pos).method_26164(AetherTags.Blocks.AETHER_DIRT)) continue;
            pos.method_33098(++y);
            return true;
        }
        return false;
    }

    public class_7151<?> method_41618() {
        return (class_7151)AetherStructureTypes.GOLD_DUNGEON.get();
    }
}

