/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners;

import com.aetherteam.aether.event.events.AetherEntityEvents;
import com.aetherteam.aether.event.hooks.EntityHooks;
import io.github.fabricators_of_create.porting_lib.core.event.BaseEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityMountEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityStruckByLightningEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerTickEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.ProjectileImpactEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.ShieldBlockEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.living.MobEffectEvent;
import io.wispforest.accessories.api.events.OnDeathCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class EntityListener {
    public static boolean onEntityJoin(class_1297 entity, class_1937 world, boolean loadedFromDisk) {
        EntityHooks.addGoals(entity);
        return true;
    }

    public static boolean onMountEntity(class_1297 mountEntity, class_1297 riderEntity, boolean mounting) {
        return !EntityHooks.dismountPrevention(riderEntity, mountEntity, !mounting);
    }

    public static void onRiderTick(class_1657 player) {
        EntityHooks.launchMount(player);
    }

    public static class_1269 onInteractWithEntity(class_1297 targetEntity, class_1657 player, class_1268 interactionHand, @Nullable class_3966 hitResult) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (hitResult == null) {
            class_238 aABB = player.method_5829().method_18804(targetEntity.method_19538()).method_1014(1.0);
            hitResult = class_1675.method_18075((class_1297)player, (class_243)player.method_33571(), (class_243)targetEntity.method_19538(), (class_238)aABB, entity -> entity == targetEntity, (double)(player.method_19538().method_1022(targetEntity.method_19538()) + 1.0));
        }
        class_243 position = hitResult != null ? hitResult.method_17784().method_1020(targetEntity.method_19538()) : targetEntity.method_19538();
        EntityHooks.skyrootBucketMilking(targetEntity, player, interactionHand);
        Optional<class_1269> result = EntityHooks.pickupBucketable(targetEntity, player, interactionHand);
        if (result.isEmpty()) {
            result = EntityHooks.interactWithArmorStand(targetEntity, player, itemStack, position, interactionHand);
        }
        return result.orElse(class_1269.field_5811);
    }

    public static void onProjectileHitEntity(ProjectileImpactEvent event) {
        class_1297 projectileEntity = event.getEntity();
        class_239 rayTraceResult = event.getRayTraceResult();
        event.setCanceled(EntityHooks.preventEntityHooked(projectileEntity, rayTraceResult));
    }

    public static void onShieldBlock(ShieldBlockEvent event) {
        if (!event.isCanceled()) {
            event.setCanceled(EntityHooks.preventSliderShieldBlock(event.getDamageSource()));
        }
    }

    public static void onLightningStrike(EntityStruckByLightningEvent event) {
        class_1297 entity = event.getEntity();
        class_1538 lightningBolt = event.getLightning();
        if (EntityHooks.lightningHitKeys(entity) || EntityHooks.thunderCrystalHitItems(entity, lightningBolt)) {
            event.setCanceled(true);
        }
    }

    public static boolean onPlayerDrops(class_1309 entity, class_1282 source, Collection<class_1542> itemDrops, int lootingLevel, boolean recentlyHit) {
        EntityHooks.trackDrops(entity, itemDrops);
        return false;
    }

    public static void onDropExperience(class_1309 livingEntity, AetherEntityEvents.ExperienceDropHelper event) {
        int experience = event.getDroppedExperience();
        int newExperience = EntityHooks.modifyExperience(livingEntity, experience);
        event.setDroppedExperience(newExperience);
    }

    public static void onEffectApply(MobEffectEvent.Applicable event) {
        class_1293 effectInstance;
        class_1309 livingEntity = event.getEntity();
        if (EntityHooks.preventInebriation(livingEntity, effectInstance = event.getEffectInstance())) {
            event.setResult(BaseEvent.Result.DENY);
        }
    }

    public static void init() {
        EntityEvents.ON_JOIN_WORLD.register(EntityListener::onEntityJoin);
        EntityMountEvents.registerForBoth(EntityListener::onMountEntity);
        PlayerTickEvents.START.register(EntityListener::onRiderTick);
        PlayerTickEvents.END.register(EntityListener::onRiderTick);
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> EntityListener.onInteractWithEntity(entity, player, hand, hitResult));
        ProjectileImpactEvent.PROJECTILE_IMPACT.register(EntityListener::onProjectileHitEntity);
        ShieldBlockEvent.EVENT.register(EntityListener::onShieldBlock);
        EntityStruckByLightningEvent.ENTITY_STRUCK_BY_LIGHTING.register(EntityListener::onLightningStrike);
        LivingEntityEvents.DROPS.register(EntityListener::onPlayerDrops);
        AetherEntityEvents.ON_EXPERIENCE_DROP.register((entity, attackingPlayer, helper) -> EntityListener.onDropExperience(entity, helper));
        MobEffectEvent.APPLICABLE.register(EntityListener::onEffectApply);
        OnDeathCallback.EVENT.register((currentState, entity, capability, damageSource, droppedStacks) -> {
            ArrayList<class_1799> droppedStacksCopy = new ArrayList<class_1799>(droppedStacks);
            boolean recentlyHit = entity.field_6037;
            int looting = class_1890.method_8226((class_1309)entity);
            droppedStacks.clear();
            droppedStacks.addAll(EntityHooks.handleEntityAccessoryDrops(entity, droppedStacksCopy, recentlyHit, looting));
            return TriState.DEFAULT;
        });
    }
}

