/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.ai.controller.FallingMoveControl;
import com.aetherteam.aether.entity.ai.goal.EatAetherGrassGoal;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.entity.ai.navigator.FallPathNavigation;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import com.aetherteam.aether.loot.AetherLoot;
import io.github.fabricators_of_create.porting_lib.attributes.PortingLibAttributes;
import io.github.fabricators_of_create.porting_lib.extensions.extensions.IShearable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;

public class Sheepuff
extends AetherAnimal
implements class_5147,
IShearable {
    private static final class_2940<Byte> DATA_WOOL_COLOR_ID = class_2945.method_12791(Sheepuff.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> DATA_PUFFED_ID = class_2945.method_12791(Sheepuff.class, (class_2941)class_2943.field_13323);
    private static final Map<class_1767, class_1935> ITEM_BY_DYE = (Map)class_156.method_654(new EnumMap(class_1767.class), p_203402_0_ -> {
        p_203402_0_.put(class_1767.field_7952, class_2246.field_10446);
        p_203402_0_.put(class_1767.field_7946, class_2246.field_10095);
        p_203402_0_.put(class_1767.field_7958, class_2246.field_10215);
        p_203402_0_.put(class_1767.field_7951, class_2246.field_10294);
        p_203402_0_.put(class_1767.field_7947, class_2246.field_10490);
        p_203402_0_.put(class_1767.field_7961, class_2246.field_10028);
        p_203402_0_.put(class_1767.field_7954, class_2246.field_10459);
        p_203402_0_.put(class_1767.field_7944, class_2246.field_10423);
        p_203402_0_.put(class_1767.field_7967, class_2246.field_10222);
        p_203402_0_.put(class_1767.field_7955, class_2246.field_10619);
        p_203402_0_.put(class_1767.field_7945, class_2246.field_10259);
        p_203402_0_.put(class_1767.field_7966, class_2246.field_10514);
        p_203402_0_.put(class_1767.field_7957, class_2246.field_10113);
        p_203402_0_.put(class_1767.field_7942, class_2246.field_10170);
        p_203402_0_.put(class_1767.field_7964, class_2246.field_10314);
        p_203402_0_.put(class_1767.field_7963, class_2246.field_10146);
    });
    private static final Map<class_1767, float[]> COLOR_ARRAY_BY_COLOR = new EnumMap<class_1767, float[]>(Arrays.stream(class_1767.values()).collect(Collectors.toMap(p_200204_0_ -> p_200204_0_, Sheepuff::createSheepColor)));
    private int eatAnimationTick;
    private int amountEaten;
    private EatAetherGrassGoal eatBlockGoal;
    private final FallPathNavigation fallNavigation;
    private final class_1409 groundNavigation;

    private static float[] createSheepColor(class_1767 p_192020_0_) {
        if (p_192020_0_ == class_1767.field_7952) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = p_192020_0_.method_7787();
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public static float[] getColorArray(class_1767 p_175513_0_) {
        return COLOR_ARRAY_BY_COLOR.get(p_175513_0_);
    }

    public Sheepuff(class_1299<? extends Sheepuff> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new FallingMoveControl((class_1308)this);
        this.fallNavigation = new FallPathNavigation((class_1308)this, level);
        this.groundNavigation = new class_1409((class_1308)this, level);
    }

    protected void method_5959() {
        this.eatBlockGoal = new EatAetherGrassGoal((class_1308)this);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.1, class_1856.method_8106(AetherTags.Items.SHEEPUFF_TEMPTATION_ITEMS), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)this.eatBlockGoal);
        this.field_6201.method_6277(6, (class_1352)new FallingRandomStrollGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.23);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DATA_WOOL_COLOR_ID, (Object)0);
        this.method_5841().method_12784(DATA_PUFFED_ID, (Object)false);
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 tag) {
        this.setColor(Sheepuff.getRandomSheepuffColor(level.method_8409()));
        return super.method_5943(level, difficulty, reason, spawnData, tag);
    }

    protected void method_5958() {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.method_5958();
    }

    public void method_6007() {
        if (this.method_37908().method_8608()) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.method_6007();
    }

    public void method_5773() {
        super.method_5773();
        if (this.getPuffed()) {
            this.method_45318();
            class_1324 gravity = this.method_5996(PortingLibAttributes.ENTITY_GRAVITY);
            if (gravity != null) {
                double fallSpeed = Math.max(gravity.method_6194() * -0.625, -0.05);
                if (this.method_18798().method_10214() < fallSpeed) {
                    this.method_18800(this.method_18798().field_1352, fallSpeed, this.method_18798().field_1350);
                }
            }
            this.field_6189 = this.fallNavigation;
        } else {
            this.field_6189 = this.groundNavigation;
        }
    }

    protected void method_6043() {
        super.method_6043();
        if (this.getPuffed()) {
            this.method_5762(0.0, 1.8, 0.0);
        }
    }

    public void method_5983() {
        ++this.amountEaten;
        if (!this.isSheared()) {
            if (this.amountEaten >= 2) {
                this.setPuffed(true);
                this.amountEaten = 0;
            }
        } else if (this.amountEaten == 1) {
            this.setSheared(false);
            this.amountEaten = 0;
        }
        if (this.method_6109()) {
            this.method_5615(60);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_1792 class_17922 = itemstack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dyeItem = (class_1769)class_17922;
            if (!this.isSheared()) {
                class_1767 color = dyeItem.method_7802();
                if (this.getColor() != color) {
                    if (this.getPuffed() && itemstack.method_7947() >= 2) {
                        player.method_6104(hand);
                        if (!player.method_37908().method_8608()) {
                            this.setColor(color);
                            if (!player.method_31549().field_7477) {
                                itemstack.method_7934(2);
                            }
                        }
                    } else if (!this.getPuffed()) {
                        player.method_6104(hand);
                        if (!player.method_37908().method_8608()) {
                            this.setColor(color);
                            if (!player.method_31549().field_7477) {
                                itemstack.method_7934(1);
                            }
                        }
                    }
                }
            }
        }
        return super.method_5992(player, hand);
    }

    public List<class_1799> onSheared(@Nullable class_1657 player, class_1799 item, class_1937 level, class_2338 pos, int fortune) {
        level.method_43129(null, (class_1297)this, (class_3414)AetherSoundEvents.ENTITY_SHEEPUFF_SHEAR.get(), player == null ? class_3419.field_15245 : class_3419.field_15248, 1.0f, 1.0f);
        if (!level.method_8608()) {
            int i;
            this.amountEaten = 0;
            if (this.getPuffed()) {
                this.setPuffed(false);
                i = 2;
            } else {
                this.setSheared(true);
                i = 1;
            }
            i += this.method_6051().method_43048(3);
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            for (int j = 0; j < i; ++j) {
                items.add(new class_1799(ITEM_BY_DYE.get(this.getColor())));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public void method_6636(class_3419 source) {
        int i;
        this.method_37908().method_43129(null, (class_1297)this, (class_3414)AetherSoundEvents.ENTITY_SHEEPUFF_SHEAR.get(), source, 1.0f, 1.0f);
        this.amountEaten = 0;
        if (this.getPuffed()) {
            this.setPuffed(false);
            i = 2;
        } else {
            this.setSheared(true);
            i = 1;
        }
        i += this.method_6051().method_43048(3);
        for (int j = 0; j < i; ++j) {
            class_1542 itementity = this.method_5870(ITEM_BY_DYE.get(this.getColor()), 1);
            if (itementity == null) continue;
            itementity.method_18799(itementity.method_18798().method_1031((double)((this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.1f), (double)(this.method_6051().method_43057() * 0.05f), (double)((this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.1f)));
        }
    }

    public boolean isShearable(class_1799 item, class_1937 world, class_2338 pos) {
        return this.method_27072();
    }

    public boolean method_27072() {
        return this.method_5805() && !this.isSheared() && !this.method_6109();
    }

    public boolean isSheared() {
        return ((Byte)this.method_5841().method_12789(DATA_WOOL_COLOR_ID) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.method_5841().method_12789(DATA_WOOL_COLOR_ID);
        if (sheared) {
            this.method_5841().method_12778(DATA_WOOL_COLOR_ID, (Object)((byte)(b0 | 0x10)));
        } else {
            this.method_5841().method_12778(DATA_WOOL_COLOR_ID, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public boolean getPuffed() {
        return (Boolean)this.method_5841().method_12789(DATA_PUFFED_ID);
    }

    public void setPuffed(boolean flag) {
        this.method_5841().method_12778(DATA_PUFFED_ID, (Object)flag);
    }

    public class_1767 getColor() {
        return class_1767.method_7791((int)((Byte)this.method_5841().method_12789(DATA_WOOL_COLOR_ID) & 0xF));
    }

    public void setColor(class_1767 dyeColor) {
        byte b0 = (Byte)this.method_5841().method_12789(DATA_WOOL_COLOR_ID);
        this.method_5841().method_12778(DATA_WOOL_COLOR_ID, (Object)((byte)(b0 & 0xF0 | dyeColor.method_7789() & 0xF)));
    }

    public static class_1767 getRandomSheepuffColor(class_5819 random) {
        int i = random.method_43048(100);
        if (i < 5) {
            return class_1767.field_7951;
        }
        if (i < 10) {
            return class_1767.field_7955;
        }
        if (i < 15) {
            return class_1767.field_7961;
        }
        if (i < 18) {
            return class_1767.field_7954;
        }
        return random.method_43048(500) == 0 ? class_1767.field_7945 : class_1767.field_7952;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(AetherTags.Items.SHEEPUFF_TEMPTATION_ITEMS);
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)AetherSoundEvents.ENTITY_SHEEPUFF_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)AetherSoundEvents.ENTITY_SHEEPUFF_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)AetherSoundEvents.ENTITY_SHEEPUFF_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)AetherSoundEvents.ENTITY_SHEEPUFF_STEP.get(), class_3419.field_15254, 0.15f, 1.0f);
    }

    public class_2960 method_5991() {
        if (this.isSheared()) {
            return this.method_5864().method_16351();
        }
        return switch (this.getColor()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1767.field_7952 -> AetherLoot.ENTITIES_SHEEPUFF_WHITE;
            case class_1767.field_7946 -> AetherLoot.ENTITIES_SHEEPUFF_ORANGE;
            case class_1767.field_7958 -> AetherLoot.ENTITIES_SHEEPUFF_MAGENTA;
            case class_1767.field_7951 -> AetherLoot.ENTITIES_SHEEPUFF_LIGHT_BLUE;
            case class_1767.field_7947 -> AetherLoot.ENTITIES_SHEEPUFF_YELLOW;
            case class_1767.field_7961 -> AetherLoot.ENTITIES_SHEEPUFF_LIME;
            case class_1767.field_7954 -> AetherLoot.ENTITIES_SHEEPUFF_PINK;
            case class_1767.field_7944 -> AetherLoot.ENTITIES_SHEEPUFF_GRAY;
            case class_1767.field_7967 -> AetherLoot.ENTITIES_SHEEPUFF_LIGHT_GRAY;
            case class_1767.field_7955 -> AetherLoot.ENTITIES_SHEEPUFF_CYAN;
            case class_1767.field_7945 -> AetherLoot.ENTITIES_SHEEPUFF_PURPLE;
            case class_1767.field_7966 -> AetherLoot.ENTITIES_SHEEPUFF_BLUE;
            case class_1767.field_7957 -> AetherLoot.ENTITIES_SHEEPUFF_BROWN;
            case class_1767.field_7942 -> AetherLoot.ENTITIES_SHEEPUFF_GREEN;
            case class_1767.field_7964 -> AetherLoot.ENTITIES_SHEEPUFF_RED;
            case class_1767.field_7963 -> AetherLoot.ENTITIES_SHEEPUFF_BLACK;
        };
    }

    protected int method_23329(float distance, float damageMultiplier) {
        return this.getPuffed() ? 0 : super.method_23329(distance, damageMultiplier);
    }

    public int method_5850() {
        return !this.method_24828() && this.getPuffed() ? 20 : super.method_5850();
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 entity) {
        Sheepuff parent = (Sheepuff)entity;
        Sheepuff baby = (Sheepuff)((class_1299)AetherEntityTypes.SHEEPUFF.get()).method_5883((class_1937)level);
        if (baby != null) {
            baby.setColor(this.getOffspringColor(this, parent));
        }
        return baby;
    }

    private class_1767 getOffspringColor(class_1429 parent1, class_1429 parent2) {
        class_1767 dyeColor1 = ((Sheepuff)parent1).getColor();
        class_1767 dyeColor2 = ((Sheepuff)parent2).getColor();
        class_8566 craftingInventory = Sheepuff.makeContainer(dyeColor1, dyeColor2);
        return this.method_37908().method_8433().method_8132(class_3956.field_17545, (class_1263)craftingInventory, this.method_37908()).map(p_213614_1_ -> p_213614_1_.method_8116((class_1263)craftingInventory, this.method_37908().method_30349())).map(class_1799::method_7909).filter(class_1769.class::isInstance).map(class_1769.class::cast).map(class_1769::method_7802).orElseGet(() -> this.method_37908().method_8409().method_43056() ? dyeColor1 : dyeColor2);
    }

    private static class_8566 makeContainer(class_1767 dyeColor1, class_1767 dyeColor2) {
        class_1715 craftingInventory = new class_1715((class_1703)new SheepuffContainer(null, -1), 2, 1);
        craftingInventory.method_5447(0, new class_1799((class_1935)class_1769.method_7803((class_1767)dyeColor1)));
        craftingInventory.method_5447(1, new class_1799((class_1935)class_1769.method_7803((class_1767)dyeColor2)));
        return craftingInventory;
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return 0.95f * size.field_18068;
    }

    public float getHeadEatPositionScale(float pos) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - pos) / 4.0f : -((float)(this.eatAnimationTick - 40) - pos) / 4.0f;
    }

    public float getHeadEatAngleScale(float angle) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - angle) / 32.0f;
            return 0.62831855f + 0.21991149f * class_3532.method_15374((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.method_36455() * ((float)Math.PI / 180);
    }

    public void method_5711(byte id) {
        if (id == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.method_5711(id);
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Sheared", this.isSheared());
        tag.method_10556("Puffed", this.getPuffed());
        tag.method_10567("Color", (byte)this.getColor().method_7789());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("Sheared")) {
            this.setSheared(tag.method_10577("Sheared"));
        }
        if (tag.method_10545("Puffed")) {
            this.setPuffed(tag.method_10577("Puffed"));
        }
        if (tag.method_10545("Color")) {
            this.setColor(class_1767.method_7791((int)tag.method_10571("Color")));
        }
    }

    public static class SheepuffContainer
    extends class_1703 {
        public SheepuffContainer(@Nullable class_3917<?> menuType, int containerId) {
            super(menuType, containerId);
        }

        public class_1799 method_7601(@Nullable class_1657 player, int index) {
            return class_1799.field_8037;
        }

        public boolean method_7597(class_1657 player) {
            return false;
        }
    }
}

