/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block;

import com.aetherteam.aether.block.FreezingBehavior;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.event.FreezeEvent;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.block.IcestoneFreezableRecipe;
import com.aetherteam.nitrogen.recipe.BlockPropertyPair;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1860;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public interface FreezingBlock
extends FreezingBehavior<class_2680> {
    public static final float SQRT_8 = class_3532.method_15355((float)8.0f);
    public static final Table<class_2248, BlockPropertyPair, IcestoneFreezableRecipe> cachedBlocks = HashBasedTable.create();
    public static final List<class_2248> cachedResults = new ArrayList<class_2248>();

    @Override
    default public int freezeFromRecipe(class_1937 level, class_2338 pos, class_2338 origin, class_2680 source, int flag) {
        if (!level.method_8608()) {
            class_2680 oldBlockState = level.method_8320(pos);
            class_2248 oldBlock = oldBlockState.method_26204();
            class_3610 fluidState = level.method_8316(pos);
            if (fluidState.method_15769() || oldBlockState.method_27852(fluidState.method_15759().method_26204())) {
                IcestoneFreezableRecipe freezableRecipe;
                BlockPropertyPair pair = FreezingBlock.matchesCache(oldBlock, oldBlockState);
                if (pair != null && (freezableRecipe = (IcestoneFreezableRecipe)((Object)cachedBlocks.get((Object)oldBlock, (Object)pair))) != null) {
                    class_2680 newBlockState = freezableRecipe.getResultState(oldBlockState);
                    class_2158.class_2159 function = freezableRecipe.getFunction();
                    return this.freezeBlockAt(level, pos, origin, oldBlockState, newBlockState, function, source, flag);
                }
            } else if (!oldBlockState.method_28498((class_2769)class_2741.field_12508)) {
                IcestoneFreezableRecipe freezableRecipe;
                oldBlockState = fluidState.method_15759();
                oldBlock = fluidState.method_15759().method_26204();
                BlockPropertyPair pair = FreezingBlock.matchesCache(oldBlock, oldBlockState);
                if (pair != null && (freezableRecipe = (IcestoneFreezableRecipe)((Object)cachedBlocks.get((Object)oldBlock, (Object)pair))) != null) {
                    level.method_22352(pos, true);
                    class_2680 newBlockState = freezableRecipe.getResultState(oldBlockState);
                    class_2158.class_2159 function = freezableRecipe.getFunction();
                    return this.freezeBlockAt(level, pos, origin, oldBlockState, newBlockState, function, source, flag);
                }
            }
        }
        return 0;
    }

    @Override
    default public FreezeEvent onFreeze(class_1936 level, class_2338 pos, class_2338 origin, class_2680 oldBlockState, class_2680 newBlockState, class_2680 source) {
        return AetherEventDispatch.onBlockFreezeFluid(level, pos, origin, oldBlockState, newBlockState, source);
    }

    public static void cacheRecipes(class_1937 level) {
        if (cachedBlocks.isEmpty()) {
            for (class_1860 recipe : level.method_8433().method_30027((class_3956)AetherRecipeTypes.ICESTONE_FREEZABLE.get())) {
                if (!(recipe instanceof IcestoneFreezableRecipe)) continue;
                IcestoneFreezableRecipe freezableRecipe = (IcestoneFreezableRecipe)recipe;
                BlockPropertyPair[] pairs = freezableRecipe.getIngredient().getPairs();
                if (pairs != null) {
                    Arrays.stream(pairs).forEach(pair -> cachedBlocks.put((Object)pair.block(), pair, (Object)freezableRecipe));
                }
                cachedResults.add(freezableRecipe.getResult().block());
            }
        }
    }

    @Nullable
    public static BlockPropertyPair matchesCache(class_2248 block, class_2680 blockState) {
        if (cachedBlocks.containsRow((Object)block)) {
            BlockPropertyPair pair = null;
            for (Map.Entry entry : cachedBlocks.row((Object)block).entrySet()) {
                if (!((BlockPropertyPair)entry.getKey()).matches(blockState)) continue;
                pair = (BlockPropertyPair)entry.getKey();
            }
            return pair;
        }
        return null;
    }
}

