/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2778;
import net.minecraft.class_3726;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.VoxelUtil;

public record MouldingShape(class_265[] shapes) implements ShapeGenerator
{
    private static final int[] mapping = new int[20];

    private static void prepareMapping() {
        class_2778[] stairsShapes = class_2778.values();
        for (int i = 0; i < 5; ++i) {
            class_2778 stairsShape = stairsShapes[i];
            int stairsShapeIndex = switch (stairsShape) {
                default -> throw new IncompatibleClassChangeError();
                case class_2778.field_12710 -> 0;
                case class_2778.field_12712, class_2778.field_12713 -> 1;
                case class_2778.field_12708, class_2778.field_12709 -> 2;
            };
            int rotationOffset = switch (stairsShape) {
                case class_2778.field_12712, class_2778.field_12708 -> 0;
                default -> 1;
            };
            for (int j = 0; j < 4; ++j) {
                MouldingShape.mapping[i * 4 + j] = stairsShapeIndex * 4 + (j + rotationOffset) % 4;
            }
        }
    }

    public static ShapeGenerator create(ShapeGenerator northStraightGenerator) {
        class_265 northStraight = ShapeGenerator.Unit.unboxOrThrow(northStraightGenerator);
        class_265 northInner = class_259.method_1084((class_265)northStraight, (class_265)VoxelUtil.rotateHorizontal(northStraight, class_2350.field_11043.method_10170()));
        class_265 northOuter = class_259.method_1072((class_265)northStraight, (class_265)VoxelUtil.rotateHorizontal(northStraight, class_2350.field_11043.method_10170()), (class_247)class_247.field_16896);
        class_265[] shapes = (class_265[])Stream.of(northStraight, northInner, northOuter).flatMap($ -> class_2350.class_2353.field_11062.method_29716().map(direction -> VoxelUtil.rotateHorizontal($, direction))).toArray(class_265[]::new);
        class_265[] mappedShapes = new class_265[20];
        for (int i = 0; i < mappedShapes.length; ++i) {
            mappedShapes[i] = shapes[mapping[i]];
        }
        return new MouldingShape(mappedShapes);
    }

    @Override
    public class_265 getShape(class_2680 blockState, class_3726 context) {
        int shape = ((class_2778)blockState.method_11654((class_2769)class_2741.field_12503)).ordinal();
        int facing = ((class_2350)blockState.method_11654((class_2769)class_2741.field_12481)).method_10161();
        return this.shapes[shape * 4 + facing];
    }

    static {
        MouldingShape.prepareMapping();
    }

    public record Unbaked(UnbakedShape wrapped) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("north_straight").forGetter(Unbaked::wrapped)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return MouldingShape.create(this.wrapped.bake(context));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.wrapped);
        }
    }
}

