/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import org.apache.commons.lang3.StringUtils;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.builder.BlockSpread;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.BuilderRuleTypes;

public record CyclePropertyRule(Map<BlockFamily, Map<String, String>> families, BlockSpread spread, Map<class_2248, Map<class_2769<?>, Set<Object>>> blocks) implements BuilderRule
{
    public static final MapCodec<CyclePropertyRule> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap(BlockFamily.CODEC, (Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING)).fieldOf("family").forGetter(CyclePropertyRule::families), (App)BlockSpread.CODEC.fieldOf("spread").forGetter(CyclePropertyRule::spread)).apply((Applicative)instance, CyclePropertyRule::of));

    public static CyclePropertyRule of(Map<BlockFamily, Map<String, String>> families, BlockSpread spread) {
        ImmutableMap.Builder blocks = ImmutableMap.builder();
        Interner interner = Interners.newStrongInterner();
        Interner valuesInterner = Interners.newStrongInterner();
        for (Map.Entry<BlockFamily, Map<String, String>> entry : families.entrySet()) {
            for (class_2248 block : entry.getKey().blocks().toList()) {
                ImmutableMap.Builder properties = ImmutableMap.builder();
                for (Map.Entry<String, String> propEntry : entry.getValue().entrySet()) {
                    try {
                        class_2769<?> property = KBlockUtils.getProperty(block.method_9564(), propEntry.getKey());
                        if (propEntry.getValue().equals("*")) {
                            properties.put(property, Set.of());
                            continue;
                        }
                        String[] values = StringUtils.split((String)propEntry.getValue(), (char)'|');
                        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
                        for (String value : values) {
                            Optional opt = property.method_11900(value);
                            if (opt.isPresent()) {
                                setBuilder.add(opt.get());
                                continue;
                            }
                            Kiwi.LOGGER.warn("Invalid value {} for property {} on block {}", new Object[]{value, property, block});
                        }
                        ImmutableSet set = setBuilder.build();
                        if (set.isEmpty()) continue;
                        properties.put(property, (Object)((Set)valuesInterner.intern((Object)set)));
                    }
                    catch (Exception exception) {}
                }
                ImmutableMap map = properties.build();
                if (map.isEmpty()) continue;
                blocks.put((Object)block, (Object)((Map)interner.intern((Object)map)));
            }
        }
        return new CyclePropertyRule(families, spread, (Map<class_2248, Map<class_2769<?>, Set<Object>>>)blocks.build());
    }

    @Override
    public BuilderRule.Type<?> type() {
        return BuilderRuleTypes.CYCLE_PROPERTY.getOrCreate();
    }

    @Override
    public Stream<class_2248> relatedBlocks() {
        return this.blocks.keySet().stream();
    }

    @Override
    public boolean matches(class_1657 player, class_1799 itemStack, class_2680 blockState) {
        return true;
    }

    @Override
    public void apply(class_1838 context, List<class_2338> positions) {
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        boolean success = false;
        HashMap usedBlocks = Maps.newHashMap();
        for (class_2338 pos : positions) {
            class_2680 oldBlock;
            class_2680 newBlock = oldBlock = level.method_8320(pos);
            class_2248 block = oldBlock.method_26204();
            class_2680 usedBlock = (class_2680)usedBlocks.get(block);
            for (Map.Entry<class_2769<?>, Set<Object>> propEntry : this.blocks.get(block).entrySet()) {
                Comparable value;
                class_2769<?> property = propEntry.getKey();
                Set<Object> values = propEntry.getValue();
                Comparable curValue = oldBlock.method_11654(property);
                if (!values.isEmpty() && !values.contains(curValue)) continue;
                Comparable comparable = value = usedBlock == null ? null : usedBlock.method_11654(property);
                if (!values.isEmpty() && !values.contains(value)) {
                    value = null;
                }
                if (value == null) {
                    while (!((value = (newBlock = (class_2680)newBlock.method_28493(property)).method_11654(property)).equals(curValue) || values.isEmpty() || values.contains(value))) {
                    }
                    continue;
                }
                newBlock = (class_2680)newBlock.method_11657(property, value);
            }
            if (!newBlock.method_26184((class_4538)level, pos)) continue;
            if (usedBlock == null) {
                usedBlocks.put(block, newBlock);
            }
            success |= level.method_8652(pos, newBlock, 18);
        }
        if (success && player != null) {
            for (class_2680 block : usedBlocks.values()) {
                this.playPlaceSound(player, block);
            }
        }
    }

    @Override
    public List<class_2338> searchPositions(class_2680 blockState, class_1838 context) {
        List<class_2338> list = List.of();
        HashMap usedBlocks = Maps.newHashMap();
        try {
            list = this.spread.collect(context, $ -> {
                Set<Object> values;
                class_2769<?> property;
                class_2248 block = $.method_26204();
                Map<class_2769<?>, Set<Object>> map = this.blocks.get(block);
                if (map == null) {
                    return false;
                }
                class_2680 usedBlock = (class_2680)usedBlocks.get(block);
                for (Map.Entry<class_2769<?>, Set<Object>> entry : map.entrySet()) {
                    property = entry.getKey();
                    values = entry.getValue();
                    Comparable curValue = $.method_11654(property);
                    if (usedBlock == null || !values.isEmpty() && !values.contains(curValue) || curValue.equals(usedBlock.method_11654(property))) continue;
                    return false;
                }
                if (usedBlock != $) {
                    if (usedBlock != null) {
                        for (Map.Entry<class_2769<?>, Set<Object>> entry : map.entrySet()) {
                            property = entry.getKey();
                            values = entry.getValue();
                            Comparable value = $.method_11654(property);
                            if (!values.isEmpty() && !values.contains(value)) continue;
                            usedBlock = (class_2680)usedBlock.method_11657(property, value);
                        }
                    }
                    usedBlocks.put(block, usedBlock);
                }
                return true;
            }, null);
        }
        catch (Exception e) {
            Kiwi.LOGGER.error("Failed to collect positions", (Throwable)e);
        }
        return list;
    }
}

