/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block;

import com.google.common.base.Supplier;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import snownee.kiwi.customization.block.GlassType;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.block.loader.KMaterial;
import snownee.kiwi.customization.placement.PlaceChoices;
import snownee.kiwi.customization.placement.PlaceSlotProvider;
import snownee.kiwi.customization.placement.SlotLink;
import snownee.kiwi.customization.shape.ShapeStorage;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.codec.CustomizationCodecs;
import snownee.kiwi.util.resource.OneTimeLoader;

public record BlockFundamentals(Map<class_2960, KMaterial> materials, Map<class_2960, GlassType> glassTypes, Map<class_2960, KBlockTemplate> templates, PlaceSlotProvider.Preparation slotProviders, SlotLink.Preparation slotLinks, PlaceChoices.Preparation placeChoices, ShapeStorage shapes, Map<class_2960, KBlockDefinition> blocks) {
    public static BlockFundamentals reload(class_3300 resourceManager, OneTimeLoader.Context context, boolean booting) {
        Map<class_2960, KMaterial> materials = OneTimeLoader.load(resourceManager, "kiwi/material", KMaterial.DIRECT_CODEC, context);
        MapCodec materialCodec = CustomizationCodecs.simpleByNameCodec(materials).optionalFieldOf("material");
        Map<class_2960, GlassType> glassTypes = OneTimeLoader.load(resourceManager, "kiwi/glass_type", GlassType.DIRECT_CODEC, context);
        MapCodec glassTypeCodec = CustomizationCodecs.simpleByNameCodec(glassTypes).optionalFieldOf("glass_type");
        CodecCreationContext creationContext = new CodecCreationContext((MapCodec<Optional<KMaterial>>)materialCodec, (MapCodec<Optional<GlassType>>)glassTypeCodec);
        Map<class_2960, KBlockTemplate> templates = OneTimeLoader.load(resourceManager, "kiwi/template/block", KBlockTemplate.codec(creationContext), context);
        if (booting) {
            templates.forEach((key, value) -> value.resolve((class_2960)key, context));
        }
        PlaceSlotProvider.Preparation slotProviders = PlaceSlotProvider.Preparation.of(() -> OneTimeLoader.load(resourceManager, "kiwi/placement/slot", PlaceSlotProvider.CODEC, context), templates);
        SlotLink.Preparation slotLinks = SlotLink.Preparation.of(() -> OneTimeLoader.load(resourceManager, "kiwi/placement/link", SlotLink.CODEC, context), slotProviders);
        PlaceChoices.Preparation placeChoices = PlaceChoices.Preparation.of(() -> OneTimeLoader.load(resourceManager, "kiwi/placement/choices", PlaceChoices.CODEC, context), templates);
        ShapeStorage shapes = ShapeStorage.reload((Supplier<Map<class_2960, UnbakedShape>>)((Supplier)() -> OneTimeLoader.load(resourceManager, "kiwi/shape", new UnbakedShapeCodec(), context)));
        Map<class_2960, KBlockDefinition> blocks = OneTimeLoader.load(resourceManager, "kiwi/block", KBlockDefinition.codec(templates, creationContext), context);
        return new BlockFundamentals(materials, glassTypes, templates, slotProviders, slotLinks, placeChoices, shapes, blocks);
    }

    public record CodecCreationContext(MapCodec<Optional<KMaterial>> materialCodec, MapCodec<Optional<GlassType>> glassTypeCodec) {
    }
}

