/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.spongepowered.configurate.transformation;

import com.vecoo.extralib.shade.checkerframework.checker.nullness.qual.Nullable;
import com.vecoo.extralib.shade.spongepowered.configurate.ConfigurateException;
import com.vecoo.extralib.shade.spongepowered.configurate.ConfigurationNode;
import com.vecoo.extralib.shade.spongepowered.configurate.transformation.ConfigurationTransformation;
import java.util.Arrays;

class ChainedConfigurationTransformation
implements ConfigurationTransformation {
    private final ConfigurationTransformation[] transformations;

    ChainedConfigurationTransformation(ConfigurationTransformation[] transformations) {
        this.transformations = Arrays.copyOf(transformations, transformations.length);
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        for (ConfigurationTransformation transformation : this.transformations) {
            try {
                transformation.apply(node);
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }
}

