/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.spongepowered.configurate.serialize;

import com.vecoo.extralib.shade.checkerframework.checker.nullness.qual.Nullable;
import com.vecoo.extralib.shade.leangen.geantyref.GenericTypeReflector;
import com.vecoo.extralib.shade.leangen.geantyref.TypeToken;
import com.vecoo.extralib.shade.spongepowered.configurate.serialize.ScalarSerializer;
import com.vecoo.extralib.shade.spongepowered.configurate.serialize.SerializationException;
import com.vecoo.extralib.shade.spongepowered.configurate.util.EnumLookup;
import java.lang.reflect.Type;
import java.util.function.Predicate;

final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    @Override
    public Enum<?> deserialize(Type type, Object obj) throws SerializationException {
        String enumConstant = obj.toString();
        @Nullable Enum ret = EnumLookup.lookupEnum(GenericTypeReflector.erase(type).asSubclass(Enum.class), enumConstant);
        if (ret == null) {
            throw new SerializationException(type, "Invalid enum constant provided, expected a value of enum, got " + enumConstant);
        }
        return ret;
    }

    @Override
    public Object serialize(Enum<?> item, Predicate<Class<?>> typeSupported) {
        return item.name();
    }
}

