/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.spongepowered.configurate.reference;

import com.vecoo.extralib.shade.checkerframework.checker.nullness.qual.Nullable;
import com.vecoo.extralib.shade.leangen.geantyref.TypeToken;
import com.vecoo.extralib.shade.spongepowered.configurate.ConfigurateException;
import com.vecoo.extralib.shade.spongepowered.configurate.ConfigurationNode;
import com.vecoo.extralib.shade.spongepowered.configurate.NodePath;
import com.vecoo.extralib.shade.spongepowered.configurate.ScopedConfigurationNode;
import com.vecoo.extralib.shade.spongepowered.configurate.reactive.Disposable;
import com.vecoo.extralib.shade.spongepowered.configurate.reactive.Publisher;
import com.vecoo.extralib.shade.spongepowered.configurate.reactive.Subscriber;
import com.vecoo.extralib.shade.spongepowered.configurate.reactive.TransactionFailedException;
import com.vecoo.extralib.shade.spongepowered.configurate.reference.ConfigurationReference;
import com.vecoo.extralib.shade.spongepowered.configurate.reference.ManualConfigurationReference;
import com.vecoo.extralib.shade.spongepowered.configurate.reference.ValueReference;
import com.vecoo.extralib.shade.spongepowered.configurate.serialize.SerializationException;
import com.vecoo.extralib.shade.spongepowered.configurate.serialize.TypeSerializer;
import com.vecoo.extralib.shade.spongepowered.configurate.util.UnmodifiableCollections;
import java.util.concurrent.Executor;
import java.util.function.Function;

class ValueReferenceImpl<T, N extends ScopedConfigurationNode<N>>
implements ValueReference<T, N>,
Publisher<T> {
    private final ManualConfigurationReference<N> root;
    private final NodePath path;
    private final TypeToken<T> type;
    private final TypeSerializer<T> serializer;
    private final Publisher.Cached<@Nullable T> deserialized;

    ValueReferenceImpl(ManualConfigurationReference<N> root, NodePath path, TypeToken<T> type, @Nullable T def) throws SerializationException {
        this.root = root;
        this.path = path;
        this.type = type;
        @Nullable TypeSerializer<T> serializer = root.node().options().serializers().get(type);
        if (serializer == null) {
            throw new SerializationException(this.path, type.getType(), "Unsupported type" + type);
        }
        this.serializer = serializer;
        this.deserialized = root.updateListener.map((I n) -> {
            try {
                return this.deserializedValueFrom(n, def);
            }
            catch (SerializationException e) {
                root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.VALUE, e));
                throw new TransactionFailedException(e);
            }
        }).cache(this.deserializedValueFrom(root.node(), def));
    }

    ValueReferenceImpl(ManualConfigurationReference<N> root, NodePath path, Class<T> type, @Nullable T def) throws SerializationException {
        this(root, path, TypeToken.get(type), def);
    }

    private @Nullable T deserializedValueFrom(N parent, @Nullable T defaultVal) throws SerializationException {
        T defaultOrEmpty;
        ConfigurationNode node = parent.node((Iterable)this.path);
        if (!node.virtual()) {
            return this.serializer.deserialize(this.type.getType(), node);
        }
        T t2 = defaultOrEmpty = defaultVal == null ? this.serializer.emptyValue(this.type.getType(), node.options()) : defaultVal;
        if (node.options().shouldCopyDefaults()) {
            this.serializer.serialize(this.type.getType(), defaultOrEmpty, node);
        }
        return defaultOrEmpty;
    }

    @Override
    public @Nullable T get() {
        return this.deserialized.get();
    }

    @Override
    public boolean set(@Nullable T value) {
        try {
            this.serializer.serialize(this.type.getType(), value, this.node());
            this.deserialized.submit(value);
            return true;
        }
        catch (SerializationException e) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.SAVING, e));
            return false;
        }
    }

    @Override
    public boolean setAndSave(@Nullable T value) {
        try {
            if (this.set(value)) {
                this.root.save();
                return true;
            }
        }
        catch (ConfigurateException e) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.SAVING, e));
        }
        return false;
    }

    @Override
    public Publisher<Boolean> setAndSaveAsync(@Nullable T value) {
        return Publisher.execute(() -> {
            this.serializer.serialize(this.type.getType(), value, this.node());
            this.deserialized.submit(value);
            this.root.save();
            return true;
        }, this.root.updates().executor());
    }

    @Override
    public boolean update(Function<@Nullable T, ? extends T> action) {
        try {
            return this.set(action.apply(this.get()));
        }
        catch (Exception t2) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.VALUE, t2));
            return false;
        }
    }

    @Override
    public Publisher<Boolean> updateAsync(Function<@Nullable T, ? extends T> action) {
        return Publisher.execute(() -> {
            @Nullable T orig = this.get();
            Object updated = action.apply(orig);
            this.serializer.serialize(this.type.getType(), updated, this.node());
            this.deserialized.submit(updated);
            this.root.save();
            return true;
        }, this.root.updates().executor());
    }

    @Override
    public N node() {
        return (N)this.root.node().node((Iterable)this.path);
    }

    @Override
    public Disposable subscribe(Subscriber<? super T> subscriber) {
        return this.deserialized.subscribe(subscriber);
    }

    @Override
    public boolean hasSubscribers() {
        return this.deserialized.hasSubscribers();
    }

    @Override
    public Executor executor() {
        return this.deserialized.executor();
    }
}

